// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.IpRangeAggregationConverter))]
public sealed partial class IpRangeAggregation
{
#if NET7_0_OR_GREATER
	public IpRangeAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IpRangeAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IpRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are used to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// Array of IP ranges.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange>? Ranges { get; set; }
}

public readonly partial struct IpRangeAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpRangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpRangeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field whose values are used to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are used to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of IP ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument> Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of IP ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument> Ranges(params Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of IP ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument> Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct IpRangeAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpRangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpRangeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field whose values are used to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are used to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of IP ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of IP ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor Ranges(params Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of IP ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}