// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.IpPrefixAggregationConverter))]
public sealed partial class IpPrefixAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpPrefixAggregation(Elastic.Clients.Elasticsearch.Field field, int prefixLength)
	{
		Field = field;
		PrefixLength = prefixLength;
	}
#if NET7_0_OR_GREATER
	public IpPrefixAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IpPrefixAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IpPrefixAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Defines whether the prefix length is appended to IP address keys in the response.
	/// </para>
	/// </summary>
	public bool? AppendPrefixLength { get; set; }

	/// <summary>
	/// <para>
	/// The IP address field to aggregation on. The field mapping type must be <c>ip</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Defines whether the prefix applies to IPv6 addresses.
	/// </para>
	/// </summary>
	public bool? IsIpv6 { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of documents in a bucket for it to be included in the response.
	/// </para>
	/// </summary>
	public long? MinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// Length of the network prefix. For IPv4 addresses the accepted range is [0, 32].
	/// For IPv6 addresses the accepted range is [0, 128].
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int PrefixLength { get; set; }
}

public readonly partial struct IpPrefixAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpPrefixAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpPrefixAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation(Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines whether the prefix length is appended to IP address keys in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument> AppendPrefixLength(bool? value = true)
	{
		Instance.AppendPrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The IP address field to aggregation on. The field mapping type must be <c>ip</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The IP address field to aggregation on. The field mapping type must be <c>ip</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines whether the prefix applies to IPv6 addresses.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument> IsIpv6(bool? value = true)
	{
		Instance.IsIpv6 = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of documents in a bucket for it to be included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument> MinDocCount(long? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Length of the network prefix. For IPv4 addresses the accepted range is [0, 32].
	/// For IPv6 addresses the accepted range is [0, 128].
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument> PrefixLength(int value)
	{
		Instance.PrefixLength = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct IpPrefixAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpPrefixAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpPrefixAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation(Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines whether the prefix length is appended to IP address keys in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor AppendPrefixLength(bool? value = true)
	{
		Instance.AppendPrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The IP address field to aggregation on. The field mapping type must be <c>ip</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The IP address field to aggregation on. The field mapping type must be <c>ip</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines whether the prefix applies to IPv6 addresses.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor IsIpv6(bool? value = true)
	{
		Instance.IsIpv6 = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of documents in a bucket for it to be included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor MinDocCount(long? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Length of the network prefix. For IPv4 addresses the accepted range is [0, 32].
	/// For IPv6 addresses the accepted range is [0, 128].
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor PrefixLength(int value)
	{
		Instance.PrefixLength = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}