// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.InferenceConfigConverter))]
public sealed partial class InferenceConfig
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public InferenceConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InferenceConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions? Classification { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions>("classification"); set => SetVariant("classification", value); }

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptions? Regression { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptions>("regression"); set => SetVariant("regression", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions value) => new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig { Classification = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptions value) => new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig { Regression = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct InferenceConfigDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig instance) => new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument> Classification(Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument> Classification()
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument> Classification(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor>? action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument> Regression(Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptions? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument> Regression()
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument> Regression(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor<TDocument>>? action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct InferenceConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig instance) => new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor Classification(Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor Classification()
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor Classification(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor>? action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor Regression(Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptions? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor Regression()
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor Regression(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor>? action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor Regression<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor<T>>? action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptionsDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}