// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.InferenceAggregationConverter))]
public sealed partial class InferenceAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceAggregation(Elastic.Clients.Elasticsearch.Name modelId)
	{
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public InferenceAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public InferenceAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Path to the buckets that contain one set of values to correlate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketsPath? BucketsPath { get; set; }

	/// <summary>
	/// <para>
	/// <c>DecimalFormat</c> pattern for the output value.
	/// If specified, the formatted value is returned in the aggregation’s <c>value_as_string</c> property.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? GapPolicy { get; set; }

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig? InferenceConfig { get; set; }

	/// <summary>
	/// <para>
	/// The ID or alias for the trained model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name ModelId { get; set; }
}

public readonly partial struct InferenceAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation(Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Path to the buckets that contain one set of values to correlate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument> BucketsPath(Elastic.Clients.Elasticsearch.Aggregations.BucketsPath? value)
	{
		Instance.BucketsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// <c>DecimalFormat</c> pattern for the output value.
	/// If specified, the formatted value is returned in the aggregation’s <c>value_as_string</c> property.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument> GapPolicy(Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? value)
	{
		Instance.GapPolicy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument> InferenceConfig(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig? value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument> InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument>> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID or alias for the trained model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument> ModelId(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.ModelId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct InferenceAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation(Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Path to the buckets that contain one set of values to correlate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor BucketsPath(Elastic.Clients.Elasticsearch.Aggregations.BucketsPath? value)
	{
		Instance.BucketsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// <c>DecimalFormat</c> pattern for the output value.
	/// If specified, the formatted value is returned in the aggregation’s <c>value_as_string</c> property.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor GapPolicy(Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? value)
	{
		Instance.GapPolicy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor InferenceConfig(Elastic.Clients.Elasticsearch.Aggregations.InferenceConfig? value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor InferenceConfig<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<T>> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Aggregations.InferenceConfigDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID or alias for the trained model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor ModelId(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.ModelId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}