// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.HdrMethodConverter))]
public sealed partial class HdrMethod
{
#if NET7_0_OR_GREATER
	public HdrMethod()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public HdrMethod()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal HdrMethod(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the resolution of values for the histogram in number of significant digits.
	/// </para>
	/// </summary>
	public int? NumberOfSignificantValueDigits { get; set; }
}

public readonly partial struct HdrMethodDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.HdrMethod Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HdrMethodDescriptor(Elastic.Clients.Elasticsearch.Aggregations.HdrMethod instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HdrMethodDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.HdrMethod(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor(Elastic.Clients.Elasticsearch.Aggregations.HdrMethod instance) => new Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.HdrMethod(Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the resolution of values for the histogram in number of significant digits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor NumberOfSignificantValueDigits(int? value)
	{
		Instance.NumberOfSignificantValueDigits = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.HdrMethod Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.HdrMethod(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.HdrMethod(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}