// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.GeohexGridAggregationConverter))]
public sealed partial class GeohexGridAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeohexGridAggregation(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public GeohexGridAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GeohexGridAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeohexGridAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Bounding box used to filter the geo-points in each bucket.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GeoBounds? Bounds { get; set; }

	/// <summary>
	/// <para>
	/// Field containing indexed <c>geo_point</c> or <c>geo_shape</c> values.
	/// If the field contains an array, <c>geohex_grid</c> aggregates all array values.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Integer zoom of the key used to defined cells or buckets
	/// in the results. Value should be between 0-15.
	/// </para>
	/// </summary>
	public int? Precision { get; set; }

	/// <summary>
	/// <para>
	/// Number of buckets returned from each shard.
	/// </para>
	/// </summary>
	public int? ShardSize { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of buckets to return.
	/// </para>
	/// </summary>
	public int? Size { get; set; }
}

public readonly partial struct GeohexGridAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeohexGridAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeohexGridAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation(Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Bounding box used to filter the geo-points in each bucket.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> Bounds(Elastic.Clients.Elasticsearch.GeoBounds? value)
	{
		Instance.Bounds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Bounding box used to filter the geo-points in each bucket.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> Bounds(System.Func<Elastic.Clients.Elasticsearch.GeoBoundsFactory, Elastic.Clients.Elasticsearch.GeoBounds> action)
	{
		Instance.Bounds = Elastic.Clients.Elasticsearch.GeoBoundsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing indexed <c>geo_point</c> or <c>geo_shape</c> values.
	/// If the field contains an array, <c>geohex_grid</c> aggregates all array values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing indexed <c>geo_point</c> or <c>geo_shape</c> values.
	/// If the field contains an array, <c>geohex_grid</c> aggregates all array values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Integer zoom of the key used to defined cells or buckets
	/// in the results. Value should be between 0-15.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> Precision(int? value)
	{
		Instance.Precision = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of buckets returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of buckets to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GeohexGridAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeohexGridAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeohexGridAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation(Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Bounding box used to filter the geo-points in each bucket.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor Bounds(Elastic.Clients.Elasticsearch.GeoBounds? value)
	{
		Instance.Bounds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Bounding box used to filter the geo-points in each bucket.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor Bounds(System.Func<Elastic.Clients.Elasticsearch.GeoBoundsFactory, Elastic.Clients.Elasticsearch.GeoBounds> action)
	{
		Instance.Bounds = Elastic.Clients.Elasticsearch.GeoBoundsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing indexed <c>geo_point</c> or <c>geo_shape</c> values.
	/// If the field contains an array, <c>geohex_grid</c> aggregates all array values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing indexed <c>geo_point</c> or <c>geo_shape</c> values.
	/// If the field contains an array, <c>geohex_grid</c> aggregates all array values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Integer zoom of the key used to defined cells or buckets
	/// in the results. Value should be between 0-15.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor Precision(int? value)
	{
		Instance.Precision = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of buckets returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of buckets to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}