// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.GeoLineAggregationConverter))]
public sealed partial class GeoLineAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoLineAggregation(Elastic.Clients.Elasticsearch.Aggregations.GeoLinePoint point, Elastic.Clients.Elasticsearch.Aggregations.GeoLineSort sort)
	{
		Point = point;
		Sort = sort;
	}
#if NET7_0_OR_GREATER
	public GeoLineAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GeoLineAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeoLineAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// When <c>true</c>, returns an additional array of the sort values in the feature properties.
	/// </para>
	/// </summary>
	public bool? IncludeSort { get; set; }

	/// <summary>
	/// <para>
	/// The name of the geo_point field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Aggregations.GeoLinePoint Point { get; set; }

	/// <summary>
	/// <para>
	/// The maximum length of the line represented in the aggregation.
	/// Valid sizes are between 1 and 10000.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// The name of the numeric field to use as the sort key for ordering the points.
	/// When the <c>geo_line</c> aggregation is nested inside a <c>time_series</c> aggregation, this field defaults to <c>@timestamp</c>, and any other value will result in error.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Aggregations.GeoLineSort Sort { get; set; }

	/// <summary>
	/// <para>
	/// The order in which the line is sorted (ascending or descending).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SortOrder? SortOrder { get; set; }
}

public readonly partial struct GeoLineAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoLineAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoLineAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation(Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// When <c>true</c>, returns an additional array of the sort values in the feature properties.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> IncludeSort(bool? value = true)
	{
		Instance.IncludeSort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the geo_point field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> Point(Elastic.Clients.Elasticsearch.Aggregations.GeoLinePoint value)
	{
		Instance.Point = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the geo_point field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> Point(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLinePointDescriptor<TDocument>> action)
	{
		Instance.Point = Elastic.Clients.Elasticsearch.Aggregations.GeoLinePointDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum length of the line represented in the aggregation.
	/// Valid sizes are between 1 and 10000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the numeric field to use as the sort key for ordering the points.
	/// When the <c>geo_line</c> aggregation is nested inside a <c>time_series</c> aggregation, this field defaults to <c>@timestamp</c>, and any other value will result in error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> Sort(Elastic.Clients.Elasticsearch.Aggregations.GeoLineSort value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the numeric field to use as the sort key for ordering the points.
	/// When the <c>geo_line</c> aggregation is nested inside a <c>time_series</c> aggregation, this field defaults to <c>@timestamp</c>, and any other value will result in error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> Sort(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLineSortDescriptor<TDocument>> action)
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.Aggregations.GeoLineSortDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The order in which the line is sorted (ascending or descending).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument> SortOrder(Elastic.Clients.Elasticsearch.SortOrder? value)
	{
		Instance.SortOrder = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GeoLineAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoLineAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoLineAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation(Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// When <c>true</c>, returns an additional array of the sort values in the feature properties.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor IncludeSort(bool? value = true)
	{
		Instance.IncludeSort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the geo_point field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor Point(Elastic.Clients.Elasticsearch.Aggregations.GeoLinePoint value)
	{
		Instance.Point = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the geo_point field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor Point(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLinePointDescriptor> action)
	{
		Instance.Point = Elastic.Clients.Elasticsearch.Aggregations.GeoLinePointDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the geo_point field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor Point<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLinePointDescriptor<T>> action)
	{
		Instance.Point = Elastic.Clients.Elasticsearch.Aggregations.GeoLinePointDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum length of the line represented in the aggregation.
	/// Valid sizes are between 1 and 10000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the numeric field to use as the sort key for ordering the points.
	/// When the <c>geo_line</c> aggregation is nested inside a <c>time_series</c> aggregation, this field defaults to <c>@timestamp</c>, and any other value will result in error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor Sort(Elastic.Clients.Elasticsearch.Aggregations.GeoLineSort value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the numeric field to use as the sort key for ordering the points.
	/// When the <c>geo_line</c> aggregation is nested inside a <c>time_series</c> aggregation, this field defaults to <c>@timestamp</c>, and any other value will result in error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor Sort(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLineSortDescriptor> action)
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.Aggregations.GeoLineSortDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the numeric field to use as the sort key for ordering the points.
	/// When the <c>geo_line</c> aggregation is nested inside a <c>time_series</c> aggregation, this field defaults to <c>@timestamp</c>, and any other value will result in error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor Sort<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLineSortDescriptor<T>> action)
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.Aggregations.GeoLineSortDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The order in which the line is sorted (ascending or descending).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor SortOrder(Elastic.Clients.Elasticsearch.SortOrder? value)
	{
		Instance.SortOrder = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}