// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.GeoDistanceAggregationConverter))]
public sealed partial class GeoDistanceAggregation
{
#if NET7_0_OR_GREATER
	public GeoDistanceAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GeoDistanceAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The distance calculation type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GeoDistanceType? DistanceType { get; set; }

	/// <summary>
	/// <para>
	/// A field of type <c>geo_point</c> used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// The origin  used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GeoLocation? Origin { get; set; }

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>? Ranges { get; set; }

	/// <summary>
	/// <para>
	/// The distance unit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.DistanceUnit? Unit { get; set; }
}

public readonly partial struct GeoDistanceAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoDistanceAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoDistanceAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The distance calculation type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> DistanceType(Elastic.Clients.Elasticsearch.GeoDistanceType? value)
	{
		Instance.DistanceType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A field of type <c>geo_point</c> used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A field of type <c>geo_point</c> used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The origin  used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Origin(Elastic.Clients.Elasticsearch.GeoLocation? value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The origin  used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Origin(System.Func<Elastic.Clients.Elasticsearch.GeoLocationFactory, Elastic.Clients.Elasticsearch.GeoLocation> action)
	{
		Instance.Origin = Elastic.Clients.Elasticsearch.GeoLocationFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Ranges(params Elastic.Clients.Elasticsearch.Aggregations.AggregationRange[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The distance unit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument> Unit(Elastic.Clients.Elasticsearch.DistanceUnit? value)
	{
		Instance.Unit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GeoDistanceAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoDistanceAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoDistanceAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The distance calculation type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor DistanceType(Elastic.Clients.Elasticsearch.GeoDistanceType? value)
	{
		Instance.DistanceType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A field of type <c>geo_point</c> used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A field of type <c>geo_point</c> used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The origin  used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Origin(Elastic.Clients.Elasticsearch.GeoLocation? value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The origin  used to evaluate the distance.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Origin(System.Func<Elastic.Clients.Elasticsearch.GeoLocationFactory, Elastic.Clients.Elasticsearch.GeoLocation> action)
	{
		Instance.Origin = Elastic.Clients.Elasticsearch.GeoLocationFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Ranges(params Elastic.Clients.Elasticsearch.Aggregations.AggregationRange[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The distance unit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor Unit(Elastic.Clients.Elasticsearch.DistanceUnit? value)
	{
		Instance.Unit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}