// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.GapPolicyConverter))]
public enum GapPolicy
{
	/// <summary>
	/// <para>
	/// Replace missing values with a zero (0) and pipeline aggregation computation will proceed as normal.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "insert_zeros")]
	InsertZeros,
	/// <summary>
	/// <para>
	/// Similar to skip, except if the metric provides a non-null, non-NaN value this value is used,
	/// otherwise the empty bucket is skipped.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "keep_values")]
	KeepValues,
	/// <summary>
	/// <para>
	/// Treats missing data as if the bucket does not exist. It will skip the bucket and
	/// continue calculating using the next available value.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "skip")]
	Skip
}