// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class GapPolicyConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.GapPolicy>
{
	private static readonly System.Text.Json.JsonEncodedText MemberInsertZeros = System.Text.Json.JsonEncodedText.Encode("insert_zeros");
	private static readonly System.Text.Json.JsonEncodedText MemberKeepValues = System.Text.Json.JsonEncodedText.Encode("keep_values");
	private static readonly System.Text.Json.JsonEncodedText MemberSkip = System.Text.Json.JsonEncodedText.Encode("skip");

	public override Elastic.Clients.Elasticsearch.Aggregations.GapPolicy Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberInsertZeros))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.InsertZeros;
		}

		if (reader.ValueTextEquals(MemberKeepValues))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.KeepValues;
		}

		if (reader.ValueTextEquals(MemberSkip))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.Skip;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberInsertZeros.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.InsertZeros;
		}

		if (string.Equals(value, MemberKeepValues.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.KeepValues;
		}

		if (string.Equals(value, MemberSkip.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.Skip;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.GapPolicy)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.GapPolicy value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.InsertZeros:
				writer.WriteStringValue(MemberInsertZeros);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.KeepValues:
				writer.WriteStringValue(MemberKeepValues);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GapPolicy.Skip:
				writer.WriteStringValue(MemberSkip);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.GapPolicy)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.GapPolicy ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.GapPolicy value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}