// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.FrequentItemSetsAggregationConverter))]
public sealed partial class FrequentItemSetsAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequentItemSetsAggregation(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField> fields)
	{
		Fields = fields;
	}
#if NET7_0_OR_GREATER
	public FrequentItemSetsAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FrequentItemSetsAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FrequentItemSetsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField> Fields { get; set; }

	/// <summary>
	/// <para>
	/// Query that filters documents from analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Filter { get; set; }

	/// <summary>
	/// <para>
	/// The minimum size of one item set.
	/// </para>
	/// </summary>
	public int? MinimumSetSize { get; set; }

	/// <summary>
	/// <para>
	/// The minimum support of one item set.
	/// </para>
	/// </summary>
	public double? MinimumSupport { get; set; }

	/// <summary>
	/// <para>
	/// The number of top item sets to return.
	/// </para>
	/// </summary>
	public int? Size { get; set; }
}

public readonly partial struct FrequentItemSetsAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequentItemSetsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequentItemSetsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField> value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> Fields(params Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> Fields(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsFieldDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsFieldDescriptor<TDocument>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query that filters documents from analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query that filters documents from analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum size of one item set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> MinimumSetSize(int? value)
	{
		Instance.MinimumSetSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum support of one item set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> MinimumSupport(double? value)
	{
		Instance.MinimumSupport = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of top item sets to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct FrequentItemSetsAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequentItemSetsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequentItemSetsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField> value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Fields(params Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Fields(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsFieldDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsFieldDescriptor.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Fields to analyze.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Fields<T>(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsFieldDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsField>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsFieldDescriptor<T>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query that filters documents from analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query that filters documents from analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Query that filters documents from analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum size of one item set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor MinimumSetSize(int? value)
	{
		Instance.MinimumSetSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum support of one item set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor MinimumSupport(double? value)
	{
		Instance.MinimumSupport = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of top item sets to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}