// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.FiltersAggregationConverter))]
public sealed partial class FiltersAggregation
{
#if NET7_0_OR_GREATER
	public FiltersAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FiltersAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filters { get; set; }

	/// <summary>
	/// <para>
	/// By default, the named filters aggregation returns the buckets as an object.
	/// Set to <c>false</c> to return the buckets as an array of objects.
	/// </para>
	/// </summary>
	public bool? Keyed => false;

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to add a bucket to the response which will contain all documents that do not match any of the given filters.
	/// </para>
	/// </summary>
	public bool? OtherBucket { get; set; }

	/// <summary>
	/// <para>
	/// The key with which the other bucket is returned.
	/// </para>
	/// </summary>
	public string? OtherBucketKey { get; set; }
}

public readonly partial struct FiltersAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FiltersAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FiltersAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument> Filters(Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument> Filters(System.Func<Elastic.Clients.Elasticsearch.Aggregations.BucketsOfQueryFactory<TDocument>, Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.QueryDsl.Query>> action)
	{
		Instance.Filters = Elastic.Clients.Elasticsearch.Aggregations.BucketsOfQueryFactory<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to add a bucket to the response which will contain all documents that do not match any of the given filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument> OtherBucket(bool? value = true)
	{
		Instance.OtherBucket = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The key with which the other bucket is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument> OtherBucketKey(string? value)
	{
		Instance.OtherBucketKey = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct FiltersAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FiltersAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FiltersAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor Filters(Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor Filters(System.Func<Elastic.Clients.Elasticsearch.Aggregations.BucketsOfQueryFactory, Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.QueryDsl.Query>> action)
	{
		Instance.Filters = Elastic.Clients.Elasticsearch.Aggregations.BucketsOfQueryFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor Filters<T>(System.Func<Elastic.Clients.Elasticsearch.Aggregations.BucketsOfQueryFactory<T>, Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.QueryDsl.Query>> action)
	{
		Instance.Filters = Elastic.Clients.Elasticsearch.Aggregations.BucketsOfQueryFactory<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to add a bucket to the response which will contain all documents that do not match any of the given filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor OtherBucket(bool? value = true)
	{
		Instance.OtherBucket = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The key with which the other bucket is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor OtherBucketKey(string? value)
	{
		Instance.OtherBucketKey = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}