// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class ExtendedStatsBucketAggregateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate>
{
	private static readonly System.Text.Json.JsonEncodedText PropAvg = System.Text.Json.JsonEncodedText.Encode("avg");
	private static readonly System.Text.Json.JsonEncodedText PropAvgAsString = System.Text.Json.JsonEncodedText.Encode("avg_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText PropMaxAsString = System.Text.Json.JsonEncodedText.Encode("max_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropMeta = System.Text.Json.JsonEncodedText.Encode("meta");
	private static readonly System.Text.Json.JsonEncodedText PropMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText PropMinAsString = System.Text.Json.JsonEncodedText.Encode("min_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropStdDeviation = System.Text.Json.JsonEncodedText.Encode("std_deviation");
	private static readonly System.Text.Json.JsonEncodedText PropStdDeviationAsString = System.Text.Json.JsonEncodedText.Encode("std_deviation_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropStdDeviationBounds = System.Text.Json.JsonEncodedText.Encode("std_deviation_bounds");
	private static readonly System.Text.Json.JsonEncodedText PropStdDeviationBoundsAsString = System.Text.Json.JsonEncodedText.Encode("std_deviation_bounds_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropStdDeviationPopulation = System.Text.Json.JsonEncodedText.Encode("std_deviation_population");
	private static readonly System.Text.Json.JsonEncodedText PropStdDeviationSampling = System.Text.Json.JsonEncodedText.Encode("std_deviation_sampling");
	private static readonly System.Text.Json.JsonEncodedText PropSum = System.Text.Json.JsonEncodedText.Encode("sum");
	private static readonly System.Text.Json.JsonEncodedText PropSumAsString = System.Text.Json.JsonEncodedText.Encode("sum_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropSumOfSquares = System.Text.Json.JsonEncodedText.Encode("sum_of_squares");
	private static readonly System.Text.Json.JsonEncodedText PropSumOfSquaresAsString = System.Text.Json.JsonEncodedText.Encode("sum_of_squares_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropVariance = System.Text.Json.JsonEncodedText.Encode("variance");
	private static readonly System.Text.Json.JsonEncodedText PropVarianceAsString = System.Text.Json.JsonEncodedText.Encode("variance_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropVariancePopulation = System.Text.Json.JsonEncodedText.Encode("variance_population");
	private static readonly System.Text.Json.JsonEncodedText PropVariancePopulationAsString = System.Text.Json.JsonEncodedText.Encode("variance_population_as_string");
	private static readonly System.Text.Json.JsonEncodedText PropVarianceSampling = System.Text.Json.JsonEncodedText.Encode("variance_sampling");
	private static readonly System.Text.Json.JsonEncodedText PropVarianceSamplingAsString = System.Text.Json.JsonEncodedText.Encode("variance_sampling_as_string");

	public override Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<double?> propAvg = default;
		LocalJsonValue<string?> propAvgAsString = default;
		LocalJsonValue<long> propCount = default;
		LocalJsonValue<double?> propMax = default;
		LocalJsonValue<string?> propMaxAsString = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, object>?> propMeta = default;
		LocalJsonValue<double?> propMin = default;
		LocalJsonValue<string?> propMinAsString = default;
		LocalJsonValue<double?> propStdDeviation = default;
		LocalJsonValue<string?> propStdDeviationAsString = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Aggregations.StandardDeviationBounds?> propStdDeviationBounds = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Aggregations.StandardDeviationBoundsAsString?> propStdDeviationBoundsAsString = default;
		LocalJsonValue<double?> propStdDeviationPopulation = default;
		LocalJsonValue<double?> propStdDeviationSampling = default;
		LocalJsonValue<double> propSum = default;
		LocalJsonValue<string?> propSumAsString = default;
		LocalJsonValue<double?> propSumOfSquares = default;
		LocalJsonValue<string?> propSumOfSquaresAsString = default;
		LocalJsonValue<double?> propVariance = default;
		LocalJsonValue<string?> propVarianceAsString = default;
		LocalJsonValue<double?> propVariancePopulation = default;
		LocalJsonValue<string?> propVariancePopulationAsString = default;
		LocalJsonValue<double?> propVarianceSampling = default;
		LocalJsonValue<string?> propVarianceSamplingAsString = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAvg.TryReadProperty(ref reader, options, PropAvg, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propAvgAsString.TryReadProperty(ref reader, options, PropAvgAsString, null))
			{
				continue;
			}

			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propMax.TryReadProperty(ref reader, options, PropMax, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propMaxAsString.TryReadProperty(ref reader, options, PropMaxAsString, null))
			{
				continue;
			}

			if (propMeta.TryReadProperty(ref reader, options, PropMeta, static System.Collections.Generic.IReadOnlyDictionary<string, object>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, object>(o, null, static object (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<object>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))!)))
			{
				continue;
			}

			if (propMin.TryReadProperty(ref reader, options, PropMin, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propMinAsString.TryReadProperty(ref reader, options, PropMinAsString, null))
			{
				continue;
			}

			if (propStdDeviation.TryReadProperty(ref reader, options, PropStdDeviation, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propStdDeviationAsString.TryReadProperty(ref reader, options, PropStdDeviationAsString, null))
			{
				continue;
			}

			if (propStdDeviationBounds.TryReadProperty(ref reader, options, PropStdDeviationBounds, null))
			{
				continue;
			}

			if (propStdDeviationBoundsAsString.TryReadProperty(ref reader, options, PropStdDeviationBoundsAsString, null))
			{
				continue;
			}

			if (propStdDeviationPopulation.TryReadProperty(ref reader, options, PropStdDeviationPopulation, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propStdDeviationSampling.TryReadProperty(ref reader, options, PropStdDeviationSampling, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propSum.TryReadProperty(ref reader, options, PropSum, null))
			{
				continue;
			}

			if (propSumAsString.TryReadProperty(ref reader, options, PropSumAsString, null))
			{
				continue;
			}

			if (propSumOfSquares.TryReadProperty(ref reader, options, PropSumOfSquares, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propSumOfSquaresAsString.TryReadProperty(ref reader, options, PropSumOfSquaresAsString, null))
			{
				continue;
			}

			if (propVariance.TryReadProperty(ref reader, options, PropVariance, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propVarianceAsString.TryReadProperty(ref reader, options, PropVarianceAsString, null))
			{
				continue;
			}

			if (propVariancePopulation.TryReadProperty(ref reader, options, PropVariancePopulation, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propVariancePopulationAsString.TryReadProperty(ref reader, options, PropVariancePopulationAsString, null))
			{
				continue;
			}

			if (propVarianceSampling.TryReadProperty(ref reader, options, PropVarianceSampling, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propVarianceSamplingAsString.TryReadProperty(ref reader, options, PropVarianceSamplingAsString, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Avg = propAvg.Value,
			AvgAsString = propAvgAsString.Value,
			Count = propCount.Value,
			Max = propMax.Value,
			MaxAsString = propMaxAsString.Value,
			Meta = propMeta.Value,
			Min = propMin.Value,
			MinAsString = propMinAsString.Value,
			StdDeviation = propStdDeviation.Value,
			StdDeviationAsString = propStdDeviationAsString.Value,
			StdDeviationBounds = propStdDeviationBounds.Value,
			StdDeviationBoundsAsString = propStdDeviationBoundsAsString.Value,
			StdDeviationPopulation = propStdDeviationPopulation.Value,
			StdDeviationSampling = propStdDeviationSampling.Value,
			Sum = propSum.Value,
			SumAsString = propSumAsString.Value,
			SumOfSquares = propSumOfSquares.Value,
			SumOfSquaresAsString = propSumOfSquaresAsString.Value,
			Variance = propVariance.Value,
			VarianceAsString = propVarianceAsString.Value,
			VariancePopulation = propVariancePopulation.Value,
			VariancePopulationAsString = propVariancePopulationAsString.Value,
			VarianceSampling = propVarianceSampling.Value,
			VarianceSamplingAsString = propVarianceSamplingAsString.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAvg, value.Avg, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropAvgAsString, value.AvgAsString, null, null);
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropMax, value.Max, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropMaxAsString, value.MaxAsString, null, null);
		writer.WriteProperty(options, PropMeta, value.Meta, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, object>? v) => w.WriteDictionaryValue<string, object>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, object v) => w.WriteValueEx<object>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))));
		writer.WriteProperty(options, PropMin, value.Min, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropMinAsString, value.MinAsString, null, null);
		writer.WriteProperty(options, PropStdDeviation, value.StdDeviation, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropStdDeviationAsString, value.StdDeviationAsString, null, null);
		writer.WriteProperty(options, PropStdDeviationBounds, value.StdDeviationBounds, null, null);
		writer.WriteProperty(options, PropStdDeviationBoundsAsString, value.StdDeviationBoundsAsString, null, null);
		writer.WriteProperty(options, PropStdDeviationPopulation, value.StdDeviationPopulation, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropStdDeviationSampling, value.StdDeviationSampling, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropSum, value.Sum, null, null);
		writer.WriteProperty(options, PropSumAsString, value.SumAsString, null, null);
		writer.WriteProperty(options, PropSumOfSquares, value.SumOfSquares, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropSumOfSquaresAsString, value.SumOfSquaresAsString, null, null);
		writer.WriteProperty(options, PropVariance, value.Variance, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropVarianceAsString, value.VarianceAsString, null, null);
		writer.WriteProperty(options, PropVariancePopulation, value.VariancePopulation, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropVariancePopulationAsString, value.VariancePopulationAsString, null, null);
		writer.WriteProperty(options, PropVarianceSampling, value.VarianceSampling, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropVarianceSamplingAsString, value.VarianceSamplingAsString, null, null);
		writer.WriteEndObject();
	}
}