// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.ExtendedBoundsConverterFactory))]
public sealed partial class ExtendedBounds<T>
{
#if NET7_0_OR_GREATER
	public ExtendedBounds()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ExtendedBounds()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ExtendedBounds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Maximum value for the bound.
	/// </para>
	/// </summary>
	public T? Max { get; set; }

	/// <summary>
	/// <para>
	/// Minimum value for the bound.
	/// </para>
	/// </summary>
	public T? Min { get; set; }
}

public readonly partial struct ExtendedBoundsOfFieldDateMathDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath> Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExtendedBoundsOfFieldDateMathDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath> instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExtendedBoundsOfFieldDateMathDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath> instance) => new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Maximum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor Max(Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath? value)
	{
		Instance.Max = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor Max()
	{
		Instance.Max = Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor Max(System.Func<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory, Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? action)
	{
		Instance.Max = Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor Min(Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath? value)
	{
		Instance.Min = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor Min()
	{
		Instance.Min = Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor Min(System.Func<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory, Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? action)
	{
		Instance.Min = Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath> Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ExtendedBoundsOfDoubleDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?> Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExtendedBoundsOfDoubleDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?> instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExtendedBoundsOfDoubleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfDoubleDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?> instance) => new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfDoubleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?>(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfDoubleDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Maximum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfDoubleDescriptor Max(double? value)
	{
		Instance.Max = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum value for the bound.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfDoubleDescriptor Min(double? value)
	{
		Instance.Min = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?> Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfDoubleDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfDoubleDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<double?>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}