// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.DiversifiedSamplerAggregationConverter))]
public sealed partial class DiversifiedSamplerAggregation
{
#if NET7_0_OR_GREATER
	public DiversifiedSamplerAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DiversifiedSamplerAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The type of value used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint? ExecutionHint { get; set; }

	/// <summary>
	/// <para>
	/// The field used to provide values used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// Limits how many documents are permitted per choice of de-duplicating value.
	/// </para>
	/// </summary>
	public int? MaxDocsPerValue { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// Limits how many top-scoring documents are collected in the sample processed on each shard.
	/// </para>
	/// </summary>
	public int? ShardSize { get; set; }
}

public readonly partial struct DiversifiedSamplerAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DiversifiedSamplerAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DiversifiedSamplerAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The type of value used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> ExecutionHint(Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint? value)
	{
		Instance.ExecutionHint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field used to provide values used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field used to provide values used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits how many documents are permitted per choice of de-duplicating value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> MaxDocsPerValue(int? value)
	{
		Instance.MaxDocsPerValue = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits how many top-scoring documents are collected in the sample processed on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument> ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DiversifiedSamplerAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DiversifiedSamplerAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DiversifiedSamplerAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The type of value used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor ExecutionHint(Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint? value)
	{
		Instance.ExecutionHint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field used to provide values used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field used to provide values used for de-duplication.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits how many documents are permitted per choice of de-duplicating value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor MaxDocsPerValue(int? value)
	{
		Instance.MaxDocsPerValue = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits how many top-scoring documents are collected in the sample processed on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}