// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.DateRangeExpressionConverter))]
public sealed partial class DateRangeExpression
{
#if NET7_0_OR_GREATER
	public DateRangeExpression()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DateRangeExpression()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateRangeExpression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Start of the range (inclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath? From { get; set; }

	/// <summary>
	/// <para>
	/// Custom key to return the range with.
	/// </para>
	/// </summary>
	public string? Key { get; set; }

	/// <summary>
	/// <para>
	/// End of the range (exclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath? To { get; set; }
}

public readonly partial struct DateRangeExpressionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeExpressionDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeExpressionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression instance) => new Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression(Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Start of the range (inclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor From(Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Start of the range (inclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor From(System.Func<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory, Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath> action)
	{
		Instance.From = Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Custom key to return the range with.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor Key(string? value)
	{
		Instance.Key = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// End of the range (exclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor To(Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath? value)
	{
		Instance.To = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// End of the range (exclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor To(System.Func<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory, Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath> action)
	{
		Instance.To = Elastic.Clients.Elasticsearch.Aggregations.FieldDateMathFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}