// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.DateRangeAggregationConverter))]
public sealed partial class DateRangeAggregation
{
#if NET7_0_OR_GREATER
	public DateRangeAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DateRangeAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// The date format used to format <c>from</c> and <c>to</c> in the response.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }

	/// <summary>
	/// <para>
	/// Array of date ranges.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression>? Ranges { get; set; }

	/// <summary>
	/// <para>
	/// Time zone used to convert dates from another time zone to UTC.
	/// </para>
	/// </summary>
	public string? TimeZone { get; set; }
}

public readonly partial struct DateRangeAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date format used to format <c>from</c> and <c>to</c> in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of date ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of date ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> Ranges(params Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of date ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Time zone used to convert dates from another time zone to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument> TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DateRangeAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date format used to format <c>from</c> and <c>to</c> in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of date ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of date ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor Ranges(params Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of date ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpression>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.DateRangeExpressionDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Time zone used to convert dates from another time zone to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}