// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.DateHistogramAggregationConverter))]
public sealed partial class DateHistogramAggregation
{
#if NET7_0_OR_GREATER
	public DateHistogramAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DateHistogramAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Calendar-aware interval.
	/// Can be specified using the unit name, such as <c>month</c>, or as a single unit quantity, such as <c>1M</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval? CalendarInterval { get; set; }

	/// <summary>
	/// <para>
	/// Enables extending the bounds of the histogram beyond the data itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? ExtendedBounds { get; set; }

	/// <summary>
	/// <para>
	/// The date field whose values are use to build a histogram.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// Fixed intervals: a fixed number of SI units and never deviate, regardless of where they fall on the calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? FixedInterval { get; set; }

	/// <summary>
	/// <para>
	/// The date format used to format <c>key_as_string</c> in the response.
	/// If no <c>format</c> is specified, the first date format specified in the field mapping is used.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Limits the histogram to specified bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? HardBounds { get; set; }
	[System.Obsolete("Deprecated in '7.2.0'. use `fixed_interval` or `calendar_interval`")]
	public Elastic.Clients.Elasticsearch.Duration? Interval { get; set; }

	/// <summary>
	/// <para>
	/// Only returns buckets that have <c>min_doc_count</c> number of documents.
	/// By default, all buckets between the first bucket that matches documents and the last one are returned.
	/// </para>
	/// </summary>
	public int? MinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Missing { get; set; }

	/// <summary>
	/// <para>
	/// Changes the start value of each bucket by the specified positive (<c>+</c>) or negative offset (<c>-</c>) duration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Offset { get; set; }

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? Order { get; set; }
	public System.Collections.Generic.IDictionary<string, object>? Params { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// Time zone used for bucketing and rounding.
	/// Defaults to Coordinated Universal Time (UTC).
	/// </para>
	/// </summary>
	public string? TimeZone { get; set; }
}

public readonly partial struct DateHistogramAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Calendar-aware interval.
	/// Can be specified using the unit name, such as <c>month</c>, or as a single unit quantity, such as <c>1M</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> CalendarInterval(Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval? value)
	{
		Instance.CalendarInterval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables extending the bounds of the histogram beyond the data itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> ExtendedBounds(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? value)
	{
		Instance.ExtendedBounds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables extending the bounds of the histogram beyond the data itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> ExtendedBounds()
	{
		Instance.ExtendedBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables extending the bounds of the histogram beyond the data itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> ExtendedBounds(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor>? action)
	{
		Instance.ExtendedBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build a histogram.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build a histogram.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Fixed intervals: a fixed number of SI units and never deviate, regardless of where they fall on the calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> FixedInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.FixedInterval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date format used to format <c>key_as_string</c> in the response.
	/// If no <c>format</c> is specified, the first date format specified in the field mapping is used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the histogram to specified bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> HardBounds(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? value)
	{
		Instance.HardBounds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the histogram to specified bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> HardBounds()
	{
		Instance.HardBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the histogram to specified bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> HardBounds(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor>? action)
	{
		Instance.HardBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(action);
		return this;
	}

	[System.Obsolete("Deprecated in '7.2.0'. use `fixed_interval` or `calendar_interval`")]
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Interval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Interval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only returns buckets that have <c>min_doc_count</c> number of documents.
	/// By default, all buckets between the first bucket that matches documents and the last one are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> MinDocCount(int? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Missing(System.DateTimeOffset? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Changes the start value of each bucket by the specified positive (<c>+</c>) or negative offset (<c>-</c>) duration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Offset(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Offset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Order(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Order()
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Order(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> AddOrder(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> AddOrder(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Time zone used for bucketing and rounding.
	/// Defaults to Coordinated Universal Time (UTC).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument> TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DateHistogramAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Calendar-aware interval.
	/// Can be specified using the unit name, such as <c>month</c>, or as a single unit quantity, such as <c>1M</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor CalendarInterval(Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval? value)
	{
		Instance.CalendarInterval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables extending the bounds of the histogram beyond the data itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor ExtendedBounds(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? value)
	{
		Instance.ExtendedBounds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables extending the bounds of the histogram beyond the data itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor ExtendedBounds()
	{
		Instance.ExtendedBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables extending the bounds of the histogram beyond the data itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor ExtendedBounds(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor>? action)
	{
		Instance.ExtendedBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build a histogram.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build a histogram.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Fixed intervals: a fixed number of SI units and never deviate, regardless of where they fall on the calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor FixedInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.FixedInterval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date format used to format <c>key_as_string</c> in the response.
	/// If no <c>format</c> is specified, the first date format specified in the field mapping is used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the histogram to specified bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor HardBounds(Elastic.Clients.Elasticsearch.Aggregations.ExtendedBounds<Elastic.Clients.Elasticsearch.Aggregations.FieldDateMath>? value)
	{
		Instance.HardBounds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the histogram to specified bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor HardBounds()
	{
		Instance.HardBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the histogram to specified bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor HardBounds(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor>? action)
	{
		Instance.HardBounds = Elastic.Clients.Elasticsearch.Aggregations.ExtendedBoundsOfFieldDateMathDescriptor.Build(action);
		return this;
	}

	[System.Obsolete("Deprecated in '7.2.0'. use `fixed_interval` or `calendar_interval`")]
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Interval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Interval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only returns buckets that have <c>min_doc_count</c> number of documents.
	/// By default, all buckets between the first bucket that matches documents and the last one are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor MinDocCount(int? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Missing(System.DateTimeOffset? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Changes the start value of each bucket by the specified positive (<c>+</c>) or negative offset (<c>-</c>) duration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Offset(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Offset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Order(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Order()
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Order(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the returned buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Order<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<T>>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor AddOrder(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor AddOrder<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Time zone used for bucketing and rounding.
	/// Defaults to Coordinated Universal Time (UTC).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}