// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class CompositeAggregationSourceConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>
{
	private static readonly System.Text.Json.JsonEncodedText VariantDateHistogram = System.Text.Json.JsonEncodedText.Encode("date_histogram");
	private static readonly System.Text.Json.JsonEncodedText VariantGeotileGrid = System.Text.Json.JsonEncodedText.Encode("geotile_grid");
	private static readonly System.Text.Json.JsonEncodedText VariantHistogram = System.Text.Json.JsonEncodedText.Encode("histogram");
	private static readonly System.Text.Json.JsonEncodedText VariantTerms = System.Text.Json.JsonEncodedText.Encode("terms");

	public override Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantDateHistogram))
			{
				variantType = VariantDateHistogram.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CompositeDateHistogramAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeotileGrid))
			{
				variantType = VariantGeotileGrid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CompositeGeoTileGridAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantHistogram))
			{
				variantType = VariantHistogram.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CompositeHistogramAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTerms))
			{
				variantType = VariantTerms.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CompositeTermsAggregation>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "date_histogram":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CompositeDateHistogramAggregation)value.Variant, null, null);
				break;
			case "geotile_grid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CompositeGeoTileGridAggregation)value.Variant, null, null);
				break;
			case "histogram":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CompositeHistogramAggregation)value.Variant, null, null);
				break;
			case "terms":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CompositeTermsAggregation)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource)}'.");
		}

		writer.WriteEndObject();
	}
}