// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.CompositeAggregationConverter))]
public sealed partial class CompositeAggregation
{
#if NET7_0_OR_GREATER
	public CompositeAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CompositeAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CompositeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.FieldValue>? After { get; set; }

	/// <summary>
	/// <para>
	/// The number of composite buckets that should be returned.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>? Sources { get; set; }
}

public readonly partial struct CompositeAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompositeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompositeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> After(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.After = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> After()
	{
		Instance.After = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> After(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue<TDocument>>? action)
	{
		Instance.After = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> AddAfter(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.FieldValue value)
	{
		Instance.After ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.FieldValue>();
		Instance.After.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> AddAfter(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.FieldValue value)
	{
		Instance.After ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.FieldValue>();
		Instance.After.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of composite buckets that should be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> Sources(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>? value)
	{
		Instance.Sources = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> Sources()
	{
		Instance.Sources = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> Sources(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource<TDocument>>? action)
	{
		Instance.Sources = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> AddSource(string key, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource value)
	{
		Instance.Sources ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>();
		Instance.Sources.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument> AddSource(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSourceDescriptor<TDocument>> action)
	{
		Instance.Sources ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>();
		Instance.Sources.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>(key, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSourceDescriptor<TDocument>.Build(action)));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct CompositeAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompositeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompositeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor After(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.After = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor After()
	{
		Instance.After = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor After(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue>? action)
	{
		Instance.After = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// When paginating, use the <c>after_key</c> value returned in the previous response to retrieve the next page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor After<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue<T>>? action)
	{
		Instance.After = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldFieldValue<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor AddAfter(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.FieldValue value)
	{
		Instance.After ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.FieldValue>();
		Instance.After.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor AddAfter<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.FieldValue value)
	{
		Instance.After ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.FieldValue>();
		Instance.After.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of composite buckets that should be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor Sources(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>? value)
	{
		Instance.Sources = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor Sources()
	{
		Instance.Sources = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor Sources(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource>? action)
	{
		Instance.Sources = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value sources used to build composite buckets.
	/// Keys are returned in the order of the <c>sources</c> definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor Sources<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource<T>>? action)
	{
		Instance.Sources = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringCompositeAggregationSource<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor AddSource(string key, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource value)
	{
		Instance.Sources ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>();
		Instance.Sources.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor AddSource(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSourceDescriptor> action)
	{
		Instance.Sources ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>();
		Instance.Sources.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>(key, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSourceDescriptor.Build(action)));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor AddSource<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSourceDescriptor<T>> action)
	{
		Instance.Sources ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>>();
		Instance.Sources.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSource>(key, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationSourceDescriptor<T>.Build(action)));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}