// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.ChiSquareHeuristicConverter))]
public sealed partial class ChiSquareHeuristic
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChiSquareHeuristic(bool backgroundIsSuperset, bool includeNegatives)
	{
		BackgroundIsSuperset = backgroundIsSuperset;
		IncludeNegatives = includeNegatives;
	}
#if NET7_0_OR_GREATER
	public ChiSquareHeuristic()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ChiSquareHeuristic()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ChiSquareHeuristic(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Set to <c>false</c> if you defined a custom background filter that represents a different set of documents that you want to compare to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool BackgroundIsSuperset { get; set; }

	/// <summary>
	/// <para>
	/// Set to <c>false</c> to filter out the terms that appear less often in the subset than in documents outside the subset.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool IncludeNegatives { get; set; }
}

public readonly partial struct ChiSquareHeuristicDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristic Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChiSquareHeuristicDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristic instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChiSquareHeuristicDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristic(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristicDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristic instance) => new Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristicDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristic(Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristicDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Set to <c>false</c> if you defined a custom background filter that represents a different set of documents that you want to compare to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristicDescriptor BackgroundIsSuperset(bool value = true)
	{
		Instance.BackgroundIsSuperset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>false</c> to filter out the terms that appear less often in the subset than in documents outside the subset.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristicDescriptor IncludeNegatives(bool value = true)
	{
		Instance.IncludeNegatives = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristic Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristicDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristicDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.ChiSquareHeuristic(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}