// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.ChangeTypeConverter))]
public sealed partial class ChangeType
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public ChangeType()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ChangeType()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ChangeType(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.Dip? Dip { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.Dip>("dip"); set => SetVariant("dip", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.DistributionChange? DistributionChange { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.DistributionChange>("distribution_change"); set => SetVariant("distribution_change", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.Indeterminable? Indeterminable { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.Indeterminable>("indeterminable"); set => SetVariant("indeterminable", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.NonStationary? NonStationary { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.NonStationary>("non_stationary"); set => SetVariant("non_stationary", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.Spike? Spike { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.Spike>("spike"); set => SetVariant("spike", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.Stationary? Stationary { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.Stationary>("stationary"); set => SetVariant("stationary", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.StepChange? StepChange { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.StepChange>("step_change"); set => SetVariant("step_change", value); }
	public Elastic.Clients.Elasticsearch.Aggregations.TrendChange? TrendChange { get => GetVariant<Elastic.Clients.Elasticsearch.Aggregations.TrendChange>("trend_change"); set => SetVariant("trend_change", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.Dip value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { Dip = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.DistributionChange value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { DistributionChange = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.Indeterminable value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { Indeterminable = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.NonStationary value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { NonStationary = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.Spike value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { Spike = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.Stationary value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { Stationary = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.StepChange value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { StepChange = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Aggregations.TrendChange value) => new Elastic.Clients.Elasticsearch.Aggregations.ChangeType { TrendChange = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}