// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class ChangeTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.ChangeType>
{
	private static readonly System.Text.Json.JsonEncodedText VariantDip = System.Text.Json.JsonEncodedText.Encode("dip");
	private static readonly System.Text.Json.JsonEncodedText VariantDistributionChange = System.Text.Json.JsonEncodedText.Encode("distribution_change");
	private static readonly System.Text.Json.JsonEncodedText VariantIndeterminable = System.Text.Json.JsonEncodedText.Encode("indeterminable");
	private static readonly System.Text.Json.JsonEncodedText VariantNonStationary = System.Text.Json.JsonEncodedText.Encode("non_stationary");
	private static readonly System.Text.Json.JsonEncodedText VariantSpike = System.Text.Json.JsonEncodedText.Encode("spike");
	private static readonly System.Text.Json.JsonEncodedText VariantStationary = System.Text.Json.JsonEncodedText.Encode("stationary");
	private static readonly System.Text.Json.JsonEncodedText VariantStepChange = System.Text.Json.JsonEncodedText.Encode("step_change");
	private static readonly System.Text.Json.JsonEncodedText VariantTrendChange = System.Text.Json.JsonEncodedText.Encode("trend_change");

	public override Elastic.Clients.Elasticsearch.Aggregations.ChangeType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantDip))
			{
				variantType = VariantDip.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.Dip>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDistributionChange))
			{
				variantType = VariantDistributionChange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DistributionChange>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantIndeterminable))
			{
				variantType = VariantIndeterminable.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.Indeterminable>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNonStationary))
			{
				variantType = VariantNonStationary.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.NonStationary>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpike))
			{
				variantType = VariantSpike.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.Spike>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantStationary))
			{
				variantType = VariantStationary.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.Stationary>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantStepChange))
			{
				variantType = VariantStepChange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StepChange>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTrendChange))
			{
				variantType = VariantTrendChange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TrendChange>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Aggregations.ChangeType(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.ChangeType value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "dip":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.Dip)value.Variant, null, null);
				break;
			case "distribution_change":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.DistributionChange)value.Variant, null, null);
				break;
			case "indeterminable":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.Indeterminable)value.Variant, null, null);
				break;
			case "non_stationary":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.NonStationary)value.Variant, null, null);
				break;
			case "spike":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.Spike)value.Variant, null, null);
				break;
			case "stationary":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.Stationary)value.Variant, null, null);
				break;
			case "step_change":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.StepChange)value.Variant, null, null);
				break;
			case "trend_change":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.TrendChange)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Aggregations.ChangeType)}'.");
		}

		writer.WriteEndObject();
	}
}