// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.CardinalityExecutionModeConverter))]
public enum CardinalityExecutionMode
{
	/// <summary>
	/// <para>
	/// Run the aggregation by using field values directly.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "direct")]
	Direct,
	/// <summary>
	/// <para>
	/// Run the aggregation by using global ordinals of the field and resolving those values after finishing a shard.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "global_ordinals")]
	GlobalOrdinals,
	/// <summary>
	/// <para>
	/// Heuristic-based mode, default in Elasticsearch 8.3 and earlier.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "save_memory_heuristic")]
	SaveMemoryHeuristic,
	/// <summary>
	/// <para>
	/// Heuristic-based mode, default in Elasticsearch 8.4 and later.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "save_time_heuristic")]
	SaveTimeHeuristic,
	/// <summary>
	/// <para>
	/// Run the aggregation by using segment ordinal values and resolving those values after each segment.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "segment_ordinals")]
	SegmentOrdinals
}