// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class CardinalityExecutionModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDirect = System.Text.Json.JsonEncodedText.Encode("direct");
	private static readonly System.Text.Json.JsonEncodedText MemberGlobalOrdinals = System.Text.Json.JsonEncodedText.Encode("global_ordinals");
	private static readonly System.Text.Json.JsonEncodedText MemberSaveMemoryHeuristic = System.Text.Json.JsonEncodedText.Encode("save_memory_heuristic");
	private static readonly System.Text.Json.JsonEncodedText MemberSaveTimeHeuristic = System.Text.Json.JsonEncodedText.Encode("save_time_heuristic");
	private static readonly System.Text.Json.JsonEncodedText MemberSegmentOrdinals = System.Text.Json.JsonEncodedText.Encode("segment_ordinals");

	public override Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDirect))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.Direct;
		}

		if (reader.ValueTextEquals(MemberGlobalOrdinals))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.GlobalOrdinals;
		}

		if (reader.ValueTextEquals(MemberSaveMemoryHeuristic))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SaveMemoryHeuristic;
		}

		if (reader.ValueTextEquals(MemberSaveTimeHeuristic))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SaveTimeHeuristic;
		}

		if (reader.ValueTextEquals(MemberSegmentOrdinals))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SegmentOrdinals;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDirect.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.Direct;
		}

		if (string.Equals(value, MemberGlobalOrdinals.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.GlobalOrdinals;
		}

		if (string.Equals(value, MemberSaveMemoryHeuristic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SaveMemoryHeuristic;
		}

		if (string.Equals(value, MemberSaveTimeHeuristic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SaveTimeHeuristic;
		}

		if (string.Equals(value, MemberSegmentOrdinals.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SegmentOrdinals;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.Direct:
				writer.WriteStringValue(MemberDirect);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.GlobalOrdinals:
				writer.WriteStringValue(MemberGlobalOrdinals);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SaveMemoryHeuristic:
				writer.WriteStringValue(MemberSaveMemoryHeuristic);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SaveTimeHeuristic:
				writer.WriteStringValue(MemberSaveTimeHeuristic);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode.SegmentOrdinals:
				writer.WriteStringValue(MemberSegmentOrdinals);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}