// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.CardinalityAggregationConverter))]
public sealed partial class CardinalityAggregation
{
#if NET7_0_OR_GREATER
	public CardinalityAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CardinalityAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CardinalityAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Mechanism by which cardinality aggregations is run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode? ExecutionHint { get; set; }

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }

	/// <summary>
	/// <para>
	/// A unique count below which counts are expected to be close to accurate.
	/// This allows to trade memory for accuracy.
	/// </para>
	/// </summary>
	public int? PrecisionThreshold { get; set; }
	public bool? Rehash { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }
}

public readonly partial struct CardinalityAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CardinalityAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CardinalityAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Mechanism by which cardinality aggregations is run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> ExecutionHint(Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode? value)
	{
		Instance.ExecutionHint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A unique count below which counts are expected to be close to accurate.
	/// This allows to trade memory for accuracy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> PrecisionThreshold(int? value)
	{
		Instance.PrecisionThreshold = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> Rehash(bool? value = true)
	{
		Instance.Rehash = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct CardinalityAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CardinalityAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CardinalityAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Mechanism by which cardinality aggregations is run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor ExecutionHint(Elastic.Clients.Elasticsearch.Aggregations.CardinalityExecutionMode? value)
	{
		Instance.ExecutionHint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A unique count below which counts are expected to be close to accurate.
	/// This allows to trade memory for accuracy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor PrecisionThreshold(int? value)
	{
		Instance.PrecisionThreshold = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor Rehash(bool? value = true)
	{
		Instance.Rehash = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}