// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class CalendarIntervalConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDay = System.Text.Json.JsonEncodedText.Encode("day");
	private static readonly System.Text.Json.JsonEncodedText MemberDay1 = System.Text.Json.JsonEncodedText.Encode("1d");
	private static readonly System.Text.Json.JsonEncodedText MemberHour = System.Text.Json.JsonEncodedText.Encode("hour");
	private static readonly System.Text.Json.JsonEncodedText MemberHour1 = System.Text.Json.JsonEncodedText.Encode("1h");
	private static readonly System.Text.Json.JsonEncodedText MemberMinute = System.Text.Json.JsonEncodedText.Encode("minute");
	private static readonly System.Text.Json.JsonEncodedText MemberMinute1 = System.Text.Json.JsonEncodedText.Encode("1m");
	private static readonly System.Text.Json.JsonEncodedText MemberMonth = System.Text.Json.JsonEncodedText.Encode("month");
	private static readonly System.Text.Json.JsonEncodedText MemberMonth1 = System.Text.Json.JsonEncodedText.Encode("1M");
	private static readonly System.Text.Json.JsonEncodedText MemberQuarter = System.Text.Json.JsonEncodedText.Encode("quarter");
	private static readonly System.Text.Json.JsonEncodedText MemberQuarter1 = System.Text.Json.JsonEncodedText.Encode("1q");
	private static readonly System.Text.Json.JsonEncodedText MemberSecond = System.Text.Json.JsonEncodedText.Encode("second");
	private static readonly System.Text.Json.JsonEncodedText MemberSecond1 = System.Text.Json.JsonEncodedText.Encode("1s");
	private static readonly System.Text.Json.JsonEncodedText MemberWeek = System.Text.Json.JsonEncodedText.Encode("week");
	private static readonly System.Text.Json.JsonEncodedText MemberWeek1 = System.Text.Json.JsonEncodedText.Encode("1w");
	private static readonly System.Text.Json.JsonEncodedText MemberYear = System.Text.Json.JsonEncodedText.Encode("year");
	private static readonly System.Text.Json.JsonEncodedText MemberYear1 = System.Text.Json.JsonEncodedText.Encode("1y");

	public override Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDay) || reader.ValueTextEquals(MemberDay1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Day;
		}

		if (reader.ValueTextEquals(MemberHour) || reader.ValueTextEquals(MemberHour1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Hour;
		}

		if (reader.ValueTextEquals(MemberMinute) || reader.ValueTextEquals(MemberMinute1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Minute;
		}

		if (reader.ValueTextEquals(MemberMonth) || reader.ValueTextEquals(MemberMonth1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Month;
		}

		if (reader.ValueTextEquals(MemberQuarter) || reader.ValueTextEquals(MemberQuarter1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Quarter;
		}

		if (reader.ValueTextEquals(MemberSecond) || reader.ValueTextEquals(MemberSecond1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Second;
		}

		if (reader.ValueTextEquals(MemberWeek) || reader.ValueTextEquals(MemberWeek1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Week;
		}

		if (reader.ValueTextEquals(MemberYear) || reader.ValueTextEquals(MemberYear1))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Year;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDay.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberDay1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Day;
		}

		if (string.Equals(value, MemberHour.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberHour1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Hour;
		}

		if (string.Equals(value, MemberMinute.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberMinute1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Minute;
		}

		if (string.Equals(value, MemberMonth.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberMonth1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Month;
		}

		if (string.Equals(value, MemberQuarter.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberQuarter1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Quarter;
		}

		if (string.Equals(value, MemberSecond.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberSecond1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Second;
		}

		if (string.Equals(value, MemberWeek.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberWeek1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Week;
		}

		if (string.Equals(value, MemberYear.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberYear1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Year;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Day:
				writer.WriteStringValue(MemberDay);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Hour:
				writer.WriteStringValue(MemberHour);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Minute:
				writer.WriteStringValue(MemberMinute);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Month:
				writer.WriteStringValue(MemberMonth);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Quarter:
				writer.WriteStringValue(MemberQuarter);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Second:
				writer.WriteStringValue(MemberSecond);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Week:
				writer.WriteStringValue(MemberWeek);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval.Year:
				writer.WriteStringValue(MemberYear);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.CalendarInterval value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}