// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.BucketSortAggregationConverter))]
public sealed partial class BucketSortAggregation
{
#if NET7_0_OR_GREATER
	public BucketSortAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public BucketSortAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BucketSortAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Buckets in positions prior to <c>from</c> will be truncated.
	/// </para>
	/// </summary>
	public int? From { get; set; }

	/// <summary>
	/// <para>
	/// The policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? GapPolicy { get; set; }

	/// <summary>
	/// <para>
	/// The number of buckets to return.
	/// Defaults to all buckets of the parent aggregation.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }
}

public readonly partial struct BucketSortAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketSortAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketSortAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Buckets in positions prior to <c>from</c> will be truncated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument> GapPolicy(Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? value)
	{
		Instance.GapPolicy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of buckets to return.
	/// Defaults to all buckets of the parent aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct BucketSortAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketSortAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketSortAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Buckets in positions prior to <c>from</c> will be truncated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor GapPolicy(Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? value)
	{
		Instance.GapPolicy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of buckets to return.
	/// Defaults to all buckets of the parent aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of fields to sort on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}