// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.BucketCorrelationFunctionCountCorrelationIndicatorConverter))]
public sealed partial class BucketCorrelationFunctionCountCorrelationIndicator
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationFunctionCountCorrelationIndicator(int docCount, System.Collections.Generic.ICollection<double> expectations)
	{
		DocCount = docCount;
		Expectations = expectations;
	}
#if NET7_0_OR_GREATER
	public BucketCorrelationFunctionCountCorrelationIndicator()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BucketCorrelationFunctionCountCorrelationIndicator()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BucketCorrelationFunctionCountCorrelationIndicator(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The total number of documents that initially created the expectations. It’s required to be greater
	/// than or equal to the sum of all values in the buckets_path as this is the originating superset of data
	/// to which the term values are correlated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int DocCount { get; set; }

	/// <summary>
	/// <para>
	/// An array of numbers with which to correlate the configured <c>bucket_path</c> values.
	/// The length of this value must always equal the number of buckets returned by the <c>bucket_path</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<double> Expectations { get; set; }

	/// <summary>
	/// <para>
	/// An array of fractions to use when averaging and calculating variance. This should be used if
	/// the pre-calculated data and the buckets_path have known gaps. The length of fractions, if provided,
	/// must equal expectations.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<double>? Fractions { get; set; }
}

public readonly partial struct BucketCorrelationFunctionCountCorrelationIndicatorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicator Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationFunctionCountCorrelationIndicatorDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicator instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationFunctionCountCorrelationIndicatorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicator(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicator instance) => new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicator(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The total number of documents that initially created the expectations. It’s required to be greater
	/// than or equal to the sum of all values in the buckets_path as this is the originating superset of data
	/// to which the term values are correlated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor DocCount(int value)
	{
		Instance.DocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numbers with which to correlate the configured <c>bucket_path</c> values.
	/// The length of this value must always equal the number of buckets returned by the <c>bucket_path</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor Expectations(System.Collections.Generic.ICollection<double> value)
	{
		Instance.Expectations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of numbers with which to correlate the configured <c>bucket_path</c> values.
	/// The length of this value must always equal the number of buckets returned by the <c>bucket_path</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor Expectations(params double[] values)
	{
		Instance.Expectations = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of fractions to use when averaging and calculating variance. This should be used if
	/// the pre-calculated data and the buckets_path have known gaps. The length of fractions, if provided,
	/// must equal expectations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor Fractions(System.Collections.Generic.ICollection<double>? value)
	{
		Instance.Fractions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of fractions to use when averaging and calculating variance. This should be used if
	/// the pre-calculated data and the buckets_path have known gaps. The length of fractions, if provided,
	/// must equal expectations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor Fractions(params double[] values)
	{
		Instance.Fractions = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicator Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicatorDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationIndicator(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}