// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.BucketCorrelationFunctionConverter))]
public sealed partial class BucketCorrelationFunction
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationFunction(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelation countCorrelation)
	{
		CountCorrelation = countCorrelation;
	}
#if NET7_0_OR_GREATER
	public BucketCorrelationFunction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BucketCorrelationFunction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BucketCorrelationFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The configuration to calculate a count correlation. This function is designed for determining the correlation of a term value and a given metric.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelation CountCorrelation { get; set; }
}

public readonly partial struct BucketCorrelationFunctionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationFunctionDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationFunctionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction instance) => new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The configuration to calculate a count correlation. This function is designed for determining the correlation of a term value and a given metric.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor CountCorrelation(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelation value)
	{
		Instance.CountCorrelation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration to calculate a count correlation. This function is designed for determining the correlation of a term value and a given metric.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor CountCorrelation(System.Action<Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationDescriptor> action)
	{
		Instance.CountCorrelation = Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionCountCorrelationDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}