// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

/// <summary>
/// <para>
/// A sibling pipeline aggregation which executes a correlation function on the configured sibling multi-bucket aggregation.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.BucketCorrelationAggregationConverter))]
public sealed partial class BucketCorrelationAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationAggregation(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction function)
	{
		Function = function;
	}
#if NET7_0_OR_GREATER
	public BucketCorrelationAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BucketCorrelationAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BucketCorrelationAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Path to the buckets that contain one set of values to correlate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketsPath? BucketsPath { get; set; }

	/// <summary>
	/// <para>
	/// The correlation function to execute.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction Function { get; set; }
}

/// <summary>
/// <para>
/// A sibling pipeline aggregation which executes a correlation function on the configured sibling multi-bucket aggregation.
/// </para>
/// </summary>
public readonly partial struct BucketCorrelationAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BucketCorrelationAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Path to the buckets that contain one set of values to correlate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor BucketsPath(Elastic.Clients.Elasticsearch.Aggregations.BucketsPath? value)
	{
		Instance.BucketsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The correlation function to execute.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor Function(Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunction value)
	{
		Instance.Function = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The correlation function to execute.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor Function(System.Action<Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor> action)
	{
		Instance.Function = Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationFunctionDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}