// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.AggregationRangeConverter))]
public sealed partial class AggregationRange
{
#if NET7_0_OR_GREATER
	public AggregationRange()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AggregationRange()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Start of the range (inclusive).
	/// </para>
	/// </summary>
	public double? From { get; set; }

	/// <summary>
	/// <para>
	/// Custom key to return the range with.
	/// </para>
	/// </summary>
	public string? Key { get; set; }

	/// <summary>
	/// <para>
	/// End of the range (exclusive).
	/// </para>
	/// </summary>
	public double? To { get; set; }
}

public readonly partial struct AggregationRangeDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.AggregationRange Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AggregationRangeDescriptor(Elastic.Clients.Elasticsearch.Aggregations.AggregationRange instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AggregationRangeDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.AggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor(Elastic.Clients.Elasticsearch.Aggregations.AggregationRange instance) => new Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.AggregationRange(Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Start of the range (inclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor From(double? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Custom key to return the range with.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor Key(string? value)
	{
		Instance.Key = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// End of the range (exclusive).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor To(double? value)
	{
		Instance.To = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.AggregationRange Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.AggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.AggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}