// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class AggregationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.Aggregation>
{
	private static readonly System.Text.Json.JsonEncodedText PropAggregations = System.Text.Json.JsonEncodedText.Encode("aggregations");
	private static readonly System.Text.Json.JsonEncodedText PropAggregations1 = System.Text.Json.JsonEncodedText.Encode("aggs");
	private static readonly System.Text.Json.JsonEncodedText PropMeta = System.Text.Json.JsonEncodedText.Encode("meta");
	private static readonly System.Text.Json.JsonEncodedText VariantAdjacencyMatrix = System.Text.Json.JsonEncodedText.Encode("adjacency_matrix");
	private static readonly System.Text.Json.JsonEncodedText VariantAutoDateHistogram = System.Text.Json.JsonEncodedText.Encode("auto_date_histogram");
	private static readonly System.Text.Json.JsonEncodedText VariantAvg = System.Text.Json.JsonEncodedText.Encode("avg");
	private static readonly System.Text.Json.JsonEncodedText VariantAvgBucket = System.Text.Json.JsonEncodedText.Encode("avg_bucket");
	private static readonly System.Text.Json.JsonEncodedText VariantBoxplot = System.Text.Json.JsonEncodedText.Encode("boxplot");
	private static readonly System.Text.Json.JsonEncodedText VariantBucketCorrelation = System.Text.Json.JsonEncodedText.Encode("bucket_correlation");
	private static readonly System.Text.Json.JsonEncodedText VariantBucketCountKsTest = System.Text.Json.JsonEncodedText.Encode("bucket_count_ks_test");
	private static readonly System.Text.Json.JsonEncodedText VariantBucketScript = System.Text.Json.JsonEncodedText.Encode("bucket_script");
	private static readonly System.Text.Json.JsonEncodedText VariantBucketSelector = System.Text.Json.JsonEncodedText.Encode("bucket_selector");
	private static readonly System.Text.Json.JsonEncodedText VariantBucketSort = System.Text.Json.JsonEncodedText.Encode("bucket_sort");
	private static readonly System.Text.Json.JsonEncodedText VariantCardinality = System.Text.Json.JsonEncodedText.Encode("cardinality");
	private static readonly System.Text.Json.JsonEncodedText VariantCartesianBounds = System.Text.Json.JsonEncodedText.Encode("cartesian_bounds");
	private static readonly System.Text.Json.JsonEncodedText VariantCartesianCentroid = System.Text.Json.JsonEncodedText.Encode("cartesian_centroid");
	private static readonly System.Text.Json.JsonEncodedText VariantCategorizeText = System.Text.Json.JsonEncodedText.Encode("categorize_text");
	private static readonly System.Text.Json.JsonEncodedText VariantChangePoint = System.Text.Json.JsonEncodedText.Encode("change_point");
	private static readonly System.Text.Json.JsonEncodedText VariantChildren = System.Text.Json.JsonEncodedText.Encode("children");
	private static readonly System.Text.Json.JsonEncodedText VariantComposite = System.Text.Json.JsonEncodedText.Encode("composite");
	private static readonly System.Text.Json.JsonEncodedText VariantCumulativeCardinality = System.Text.Json.JsonEncodedText.Encode("cumulative_cardinality");
	private static readonly System.Text.Json.JsonEncodedText VariantCumulativeSum = System.Text.Json.JsonEncodedText.Encode("cumulative_sum");
	private static readonly System.Text.Json.JsonEncodedText VariantDateHistogram = System.Text.Json.JsonEncodedText.Encode("date_histogram");
	private static readonly System.Text.Json.JsonEncodedText VariantDateRange = System.Text.Json.JsonEncodedText.Encode("date_range");
	private static readonly System.Text.Json.JsonEncodedText VariantDerivative = System.Text.Json.JsonEncodedText.Encode("derivative");
	private static readonly System.Text.Json.JsonEncodedText VariantDiversifiedSampler = System.Text.Json.JsonEncodedText.Encode("diversified_sampler");
	private static readonly System.Text.Json.JsonEncodedText VariantExtendedStats = System.Text.Json.JsonEncodedText.Encode("extended_stats");
	private static readonly System.Text.Json.JsonEncodedText VariantExtendedStatsBucket = System.Text.Json.JsonEncodedText.Encode("extended_stats_bucket");
	private static readonly System.Text.Json.JsonEncodedText VariantFilter = System.Text.Json.JsonEncodedText.Encode("filter");
	private static readonly System.Text.Json.JsonEncodedText VariantFilters = System.Text.Json.JsonEncodedText.Encode("filters");
	private static readonly System.Text.Json.JsonEncodedText VariantFrequentItemSets = System.Text.Json.JsonEncodedText.Encode("frequent_item_sets");
	private static readonly System.Text.Json.JsonEncodedText VariantFrequentItemSets1 = System.Text.Json.JsonEncodedText.Encode("frequent_items");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoBounds = System.Text.Json.JsonEncodedText.Encode("geo_bounds");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoCentroid = System.Text.Json.JsonEncodedText.Encode("geo_centroid");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoDistance = System.Text.Json.JsonEncodedText.Encode("geo_distance");
	private static readonly System.Text.Json.JsonEncodedText VariantGeohashGrid = System.Text.Json.JsonEncodedText.Encode("geohash_grid");
	private static readonly System.Text.Json.JsonEncodedText VariantGeohexGrid = System.Text.Json.JsonEncodedText.Encode("geohex_grid");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoLine = System.Text.Json.JsonEncodedText.Encode("geo_line");
	private static readonly System.Text.Json.JsonEncodedText VariantGeotileGrid = System.Text.Json.JsonEncodedText.Encode("geotile_grid");
	private static readonly System.Text.Json.JsonEncodedText VariantGlobal = System.Text.Json.JsonEncodedText.Encode("global");
	private static readonly System.Text.Json.JsonEncodedText VariantHistogram = System.Text.Json.JsonEncodedText.Encode("histogram");
	private static readonly System.Text.Json.JsonEncodedText VariantInference = System.Text.Json.JsonEncodedText.Encode("inference");
	private static readonly System.Text.Json.JsonEncodedText VariantIpPrefix = System.Text.Json.JsonEncodedText.Encode("ip_prefix");
	private static readonly System.Text.Json.JsonEncodedText VariantIpRange = System.Text.Json.JsonEncodedText.Encode("ip_range");
	private static readonly System.Text.Json.JsonEncodedText VariantLine = System.Text.Json.JsonEncodedText.Encode("line");
	private static readonly System.Text.Json.JsonEncodedText VariantMatrixStats = System.Text.Json.JsonEncodedText.Encode("matrix_stats");
	private static readonly System.Text.Json.JsonEncodedText VariantMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText VariantMaxBucket = System.Text.Json.JsonEncodedText.Encode("max_bucket");
	private static readonly System.Text.Json.JsonEncodedText VariantMedianAbsoluteDeviation = System.Text.Json.JsonEncodedText.Encode("median_absolute_deviation");
	private static readonly System.Text.Json.JsonEncodedText VariantMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText VariantMinBucket = System.Text.Json.JsonEncodedText.Encode("min_bucket");
	private static readonly System.Text.Json.JsonEncodedText VariantMissing = System.Text.Json.JsonEncodedText.Encode("missing");
	private static readonly System.Text.Json.JsonEncodedText VariantMovingFn = System.Text.Json.JsonEncodedText.Encode("moving_fn");
	private static readonly System.Text.Json.JsonEncodedText VariantMovingPercentiles = System.Text.Json.JsonEncodedText.Encode("moving_percentiles");
	private static readonly System.Text.Json.JsonEncodedText VariantMultiTerms = System.Text.Json.JsonEncodedText.Encode("multi_terms");
	private static readonly System.Text.Json.JsonEncodedText VariantNested = System.Text.Json.JsonEncodedText.Encode("nested");
	private static readonly System.Text.Json.JsonEncodedText VariantNormalize = System.Text.Json.JsonEncodedText.Encode("normalize");
	private static readonly System.Text.Json.JsonEncodedText VariantParent = System.Text.Json.JsonEncodedText.Encode("parent");
	private static readonly System.Text.Json.JsonEncodedText VariantPercentileRanks = System.Text.Json.JsonEncodedText.Encode("percentile_ranks");
	private static readonly System.Text.Json.JsonEncodedText VariantPercentiles = System.Text.Json.JsonEncodedText.Encode("percentiles");
	private static readonly System.Text.Json.JsonEncodedText VariantPercentilesBucket = System.Text.Json.JsonEncodedText.Encode("percentiles_bucket");
	private static readonly System.Text.Json.JsonEncodedText VariantRandomSampler = System.Text.Json.JsonEncodedText.Encode("random_sampler");
	private static readonly System.Text.Json.JsonEncodedText VariantRange = System.Text.Json.JsonEncodedText.Encode("range");
	private static readonly System.Text.Json.JsonEncodedText VariantRareTerms = System.Text.Json.JsonEncodedText.Encode("rare_terms");
	private static readonly System.Text.Json.JsonEncodedText VariantRate = System.Text.Json.JsonEncodedText.Encode("rate");
	private static readonly System.Text.Json.JsonEncodedText VariantReverseNested = System.Text.Json.JsonEncodedText.Encode("reverse_nested");
	private static readonly System.Text.Json.JsonEncodedText VariantSampler = System.Text.Json.JsonEncodedText.Encode("sampler");
	private static readonly System.Text.Json.JsonEncodedText VariantScriptedMetric = System.Text.Json.JsonEncodedText.Encode("scripted_metric");
	private static readonly System.Text.Json.JsonEncodedText VariantSerialDiff = System.Text.Json.JsonEncodedText.Encode("serial_diff");
	private static readonly System.Text.Json.JsonEncodedText VariantSignificantTerms = System.Text.Json.JsonEncodedText.Encode("significant_terms");
	private static readonly System.Text.Json.JsonEncodedText VariantSignificantText = System.Text.Json.JsonEncodedText.Encode("significant_text");
	private static readonly System.Text.Json.JsonEncodedText VariantStats = System.Text.Json.JsonEncodedText.Encode("stats");
	private static readonly System.Text.Json.JsonEncodedText VariantStatsBucket = System.Text.Json.JsonEncodedText.Encode("stats_bucket");
	private static readonly System.Text.Json.JsonEncodedText VariantStringStats = System.Text.Json.JsonEncodedText.Encode("string_stats");
	private static readonly System.Text.Json.JsonEncodedText VariantSum = System.Text.Json.JsonEncodedText.Encode("sum");
	private static readonly System.Text.Json.JsonEncodedText VariantSumBucket = System.Text.Json.JsonEncodedText.Encode("sum_bucket");
	private static readonly System.Text.Json.JsonEncodedText VariantTerms = System.Text.Json.JsonEncodedText.Encode("terms");
	private static readonly System.Text.Json.JsonEncodedText VariantTimeSeries = System.Text.Json.JsonEncodedText.Encode("time_series");
	private static readonly System.Text.Json.JsonEncodedText VariantTopHits = System.Text.Json.JsonEncodedText.Encode("top_hits");
	private static readonly System.Text.Json.JsonEncodedText VariantTopMetrics = System.Text.Json.JsonEncodedText.Encode("top_metrics");
	private static readonly System.Text.Json.JsonEncodedText VariantTTest = System.Text.Json.JsonEncodedText.Encode("t_test");
	private static readonly System.Text.Json.JsonEncodedText VariantValueCount = System.Text.Json.JsonEncodedText.Encode("value_count");
	private static readonly System.Text.Json.JsonEncodedText VariantVariableWidthHistogram = System.Text.Json.JsonEncodedText.Encode("variable_width_histogram");
	private static readonly System.Text.Json.JsonEncodedText VariantWeightedAvg = System.Text.Json.JsonEncodedText.Encode("weighted_avg");

	public override Elastic.Clients.Elasticsearch.Aggregations.Aggregation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>?> propAggregations = default;
		LocalJsonValue<System.Collections.Generic.IDictionary<string, object>?> propMeta = default;
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAggregations.TryReadProperty(ref reader, options, PropAggregations, static System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>(o, null, null)) || propAggregations.TryReadProperty(ref reader, options, PropAggregations1, static System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>(o, null, null)))
			{
				continue;
			}

			if (propMeta.TryReadProperty(ref reader, options, PropMeta, static System.Collections.Generic.IDictionary<string, object>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, object>(o, null, static object (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<object>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))!)))
			{
				continue;
			}

			if (reader.ValueTextEquals(VariantAdjacencyMatrix))
			{
				variantType = VariantAdjacencyMatrix.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantAutoDateHistogram))
			{
				variantType = VariantAutoDateHistogram.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantAvg))
			{
				variantType = VariantAvg.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.AverageAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantAvgBucket))
			{
				variantType = VariantAvgBucket.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.AverageBucketAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBoxplot))
			{
				variantType = VariantBoxplot.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBucketCorrelation))
			{
				variantType = VariantBucketCorrelation.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBucketCountKsTest))
			{
				variantType = VariantBucketCountKsTest.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BucketKsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBucketScript))
			{
				variantType = VariantBucketScript.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BucketScriptAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBucketSelector))
			{
				variantType = VariantBucketSelector.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BucketSelectorAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBucketSort))
			{
				variantType = VariantBucketSort.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCardinality))
			{
				variantType = VariantCardinality.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCartesianBounds))
			{
				variantType = VariantCartesianBounds.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCartesianCentroid))
			{
				variantType = VariantCartesianCentroid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCategorizeText))
			{
				variantType = VariantCategorizeText.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CategorizeTextAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantChangePoint))
			{
				variantType = VariantChangePoint.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantChildren))
			{
				variantType = VariantChildren.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantComposite))
			{
				variantType = VariantComposite.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCumulativeCardinality))
			{
				variantType = VariantCumulativeCardinality.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCumulativeSum))
			{
				variantType = VariantCumulativeSum.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CumulativeSumAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDateHistogram))
			{
				variantType = VariantDateHistogram.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDateRange))
			{
				variantType = VariantDateRange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDerivative))
			{
				variantType = VariantDerivative.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDiversifiedSampler))
			{
				variantType = VariantDiversifiedSampler.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantExtendedStats))
			{
				variantType = VariantExtendedStats.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantExtendedStatsBucket))
			{
				variantType = VariantExtendedStatsBucket.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFilter))
			{
				variantType = VariantFilter.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Query>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFilters))
			{
				variantType = VariantFilters.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFrequentItemSets) || reader.ValueTextEquals(VariantFrequentItemSets1))
			{
				variantType = VariantFrequentItemSets.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoBounds))
			{
				variantType = VariantGeoBounds.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoCentroid))
			{
				variantType = VariantGeoCentroid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoDistance))
			{
				variantType = VariantGeoDistance.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeohashGrid))
			{
				variantType = VariantGeohashGrid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeohexGrid))
			{
				variantType = VariantGeohexGrid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoLine))
			{
				variantType = VariantGeoLine.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeotileGrid))
			{
				variantType = VariantGeotileGrid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGlobal))
			{
				variantType = VariantGlobal.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantHistogram))
			{
				variantType = VariantHistogram.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantInference))
			{
				variantType = VariantInference.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantIpPrefix))
			{
				variantType = VariantIpPrefix.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantIpRange))
			{
				variantType = VariantIpRange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantLine))
			{
				variantType = VariantLine.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMatrixStats))
			{
				variantType = VariantMatrixStats.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMax))
			{
				variantType = VariantMax.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MaxAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMaxBucket))
			{
				variantType = VariantMaxBucket.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MaxBucketAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMedianAbsoluteDeviation))
			{
				variantType = VariantMedianAbsoluteDeviation.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMin))
			{
				variantType = VariantMin.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MinAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMinBucket))
			{
				variantType = VariantMinBucket.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MinBucketAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMissing))
			{
				variantType = VariantMissing.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MissingAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMovingFn))
			{
				variantType = VariantMovingFn.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MovingFunctionAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMovingPercentiles))
			{
				variantType = VariantMovingPercentiles.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMultiTerms))
			{
				variantType = VariantMultiTerms.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNested))
			{
				variantType = VariantNested.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.NestedAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNormalize))
			{
				variantType = VariantNormalize.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.NormalizeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantParent))
			{
				variantType = VariantParent.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ParentAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPercentileRanks))
			{
				variantType = VariantPercentileRanks.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPercentiles))
			{
				variantType = VariantPercentiles.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPercentilesBucket))
			{
				variantType = VariantPercentilesBucket.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRandomSampler))
			{
				variantType = VariantRandomSampler.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRange))
			{
				variantType = VariantRange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRareTerms))
			{
				variantType = VariantRareTerms.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRate))
			{
				variantType = VariantRate.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.RateAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantReverseNested))
			{
				variantType = VariantReverseNested.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSampler))
			{
				variantType = VariantSampler.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScriptedMetric))
			{
				variantType = VariantScriptedMetric.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSerialDiff))
			{
				variantType = VariantSerialDiff.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SerialDifferencingAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSignificantTerms))
			{
				variantType = VariantSignificantTerms.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SignificantTermsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSignificantText))
			{
				variantType = VariantSignificantText.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SignificantTextAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantStats))
			{
				variantType = VariantStats.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StatsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantStatsBucket))
			{
				variantType = VariantStatsBucket.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantStringStats))
			{
				variantType = VariantStringStats.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSum))
			{
				variantType = VariantSum.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SumAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSumBucket))
			{
				variantType = VariantSumBucket.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SumBucketAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTerms))
			{
				variantType = VariantTerms.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTimeSeries))
			{
				variantType = VariantTimeSeries.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTopHits))
			{
				variantType = VariantTopHits.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTopMetrics))
			{
				variantType = VariantTopMetrics.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTTest))
			{
				variantType = VariantTTest.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantValueCount))
			{
				variantType = VariantValueCount.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantVariableWidthHistogram))
			{
				variantType = VariantVariableWidthHistogram.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantWeightedAvg))
			{
				variantType = VariantWeightedAvg.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregation>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Aggregations.Aggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant,
			Aggregations = propAggregations.Value,
			Meta = propMeta.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "adjacency_matrix":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregation)value.Variant, null, null);
				break;
			case "auto_date_histogram":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregation)value.Variant, null, null);
				break;
			case "avg":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.AverageAggregation)value.Variant, null, null);
				break;
			case "avg_bucket":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.AverageBucketAggregation)value.Variant, null, null);
				break;
			case "boxplot":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregation)value.Variant, null, null);
				break;
			case "bucket_correlation":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.BucketCorrelationAggregation)value.Variant, null, null);
				break;
			case "bucket_count_ks_test":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.BucketKsAggregation)value.Variant, null, null);
				break;
			case "bucket_script":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.BucketScriptAggregation)value.Variant, null, null);
				break;
			case "bucket_selector":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.BucketSelectorAggregation)value.Variant, null, null);
				break;
			case "bucket_sort":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.BucketSortAggregation)value.Variant, null, null);
				break;
			case "cardinality":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation)value.Variant, null, null);
				break;
			case "cartesian_bounds":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregation)value.Variant, null, null);
				break;
			case "cartesian_centroid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregation)value.Variant, null, null);
				break;
			case "categorize_text":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CategorizeTextAggregation)value.Variant, null, null);
				break;
			case "change_point":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregation)value.Variant, null, null);
				break;
			case "children":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregation)value.Variant, null, null);
				break;
			case "composite":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation)value.Variant, null, null);
				break;
			case "cumulative_cardinality":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregation)value.Variant, null, null);
				break;
			case "cumulative_sum":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CumulativeSumAggregation)value.Variant, null, null);
				break;
			case "date_histogram":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregation)value.Variant, null, null);
				break;
			case "date_range":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation)value.Variant, null, null);
				break;
			case "derivative":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregation)value.Variant, null, null);
				break;
			case "diversified_sampler":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.DiversifiedSamplerAggregation)value.Variant, null, null);
				break;
			case "extended_stats":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregation)value.Variant, null, null);
				break;
			case "extended_stats_bucket":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregation)value.Variant, null, null);
				break;
			case "filter":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Query)value.Variant, null, null);
				break;
			case "filters":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregation)value.Variant, null, null);
				break;
			case "frequent_item_sets":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregation)value.Variant, null, null);
				break;
			case "geo_bounds":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregation)value.Variant, null, null);
				break;
			case "geo_centroid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregation)value.Variant, null, null);
				break;
			case "geo_distance":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregation)value.Variant, null, null);
				break;
			case "geohash_grid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregation)value.Variant, null, null);
				break;
			case "geohex_grid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregation)value.Variant, null, null);
				break;
			case "geo_line":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation)value.Variant, null, null);
				break;
			case "geotile_grid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregation)value.Variant, null, null);
				break;
			case "global":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregation)value.Variant, null, null);
				break;
			case "histogram":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregation)value.Variant, null, null);
				break;
			case "inference":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregation)value.Variant, null, null);
				break;
			case "ip_prefix":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregation)value.Variant, null, null);
				break;
			case "ip_range":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregation)value.Variant, null, null);
				break;
			case "line":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregation)value.Variant, null, null);
				break;
			case "matrix_stats":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregation)value.Variant, null, null);
				break;
			case "max":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MaxAggregation)value.Variant, null, null);
				break;
			case "max_bucket":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MaxBucketAggregation)value.Variant, null, null);
				break;
			case "median_absolute_deviation":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregation)value.Variant, null, null);
				break;
			case "min":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MinAggregation)value.Variant, null, null);
				break;
			case "min_bucket":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MinBucketAggregation)value.Variant, null, null);
				break;
			case "missing":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MissingAggregation)value.Variant, null, null);
				break;
			case "moving_fn":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MovingFunctionAggregation)value.Variant, null, null);
				break;
			case "moving_percentiles":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation)value.Variant, null, null);
				break;
			case "multi_terms":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation)value.Variant, null, null);
				break;
			case "nested":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.NestedAggregation)value.Variant, null, null);
				break;
			case "normalize":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.NormalizeAggregation)value.Variant, null, null);
				break;
			case "parent":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ParentAggregation)value.Variant, null, null);
				break;
			case "percentile_ranks":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation)value.Variant, null, null);
				break;
			case "percentiles":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation)value.Variant, null, null);
				break;
			case "percentiles_bucket":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregation)value.Variant, null, null);
				break;
			case "random_sampler":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation)value.Variant, null, null);
				break;
			case "range":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation)value.Variant, null, null);
				break;
			case "rare_terms":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation)value.Variant, null, null);
				break;
			case "rate":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.RateAggregation)value.Variant, null, null);
				break;
			case "reverse_nested":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregation)value.Variant, null, null);
				break;
			case "sampler":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation)value.Variant, null, null);
				break;
			case "scripted_metric":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation)value.Variant, null, null);
				break;
			case "serial_diff":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.SerialDifferencingAggregation)value.Variant, null, null);
				break;
			case "significant_terms":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.SignificantTermsAggregation)value.Variant, null, null);
				break;
			case "significant_text":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.SignificantTextAggregation)value.Variant, null, null);
				break;
			case "stats":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.StatsAggregation)value.Variant, null, null);
				break;
			case "stats_bucket":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregation)value.Variant, null, null);
				break;
			case "string_stats":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregation)value.Variant, null, null);
				break;
			case "sum":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.SumAggregation)value.Variant, null, null);
				break;
			case "sum_bucket":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.SumBucketAggregation)value.Variant, null, null);
				break;
			case "terms":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation)value.Variant, null, null);
				break;
			case "time_series":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation)value.Variant, null, null);
				break;
			case "top_hits":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregation)value.Variant, null, null);
				break;
			case "top_metrics":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation)value.Variant, null, null);
				break;
			case "t_test":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation)value.Variant, null, null);
				break;
			case "value_count":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregation)value.Variant, null, null);
				break;
			case "variable_width_histogram":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation)value.Variant, null, null);
				break;
			case "weighted_avg":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregation)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Aggregations.Aggregation)}'.");
		}

		writer.WriteProperty(options, PropAggregations, value.Aggregations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>(o, v, null, null));
		writer.WriteProperty(options, PropMeta, value.Meta, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, object>? v) => w.WriteDictionaryValue<string, object>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, object v) => w.WriteValueEx<object>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))));
		writer.WriteEndObject();
	}
}