// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.AggregateDictionaryConverter))]
public sealed partial class AggregateDictionary : Elastic.Clients.Elasticsearch.IsAReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.IAggregate>
{
	public AggregateDictionary(System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.IAggregate> backingDictionary) : base(backingDictionary)
	{
	}

	public bool TryGetAggregate(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.Aggregations.IAggregate value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetAggregate<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, IAggregate
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregate? GetAdjacencyMatrix(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregate? GetAutoDateHistogram(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.AverageAggregate? GetAverage(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.AverageAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregate? GetBoxplot(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.BucketMetricValueAggregate? GetBucketMetricValue(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.BucketMetricValueAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregate? GetCardinality(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregate? GetCartesianBounds(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregate? GetCartesianCentroid(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregate? GetChangePoint(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregate? GetChildren(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregate? GetComposite(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregate? GetDateHistogram(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregate? GetDateRange(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregate? GetDerivative(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.DoubleTermsAggregate? GetDoubleTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.DoubleTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregate? GetExtendedStats(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate? GetExtendedStatsBucket(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.FilterAggregate? GetFilter(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.FilterAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregate? GetFilters(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregate? GetFrequentItemSets(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregate? GetGeoBounds(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregate? GetGeoCentroid(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregate? GetGeoDistance(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregate? GetGeoLine(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregate? GetGeohashGrid(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregate? GetGeohexGrid(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregate? GetGeotileGrid(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregate? GetGlobal(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.HdrPercentileRanksAggregate? GetHdrPercentileRanks(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.HdrPercentileRanksAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.HdrPercentilesAggregate? GetHdrPercentiles(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.HdrPercentilesAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregate? GetHistogram(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregate? GetInference(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregate? GetIpPrefix(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregate? GetIpRange(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.LongRareTermsAggregate? GetLongRareTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.LongRareTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.LongTermsAggregate? GetLongTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.LongTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregate? GetMatrixStats(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.MaxAggregate? GetMax(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.MaxAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregate? GetMedianAbsoluteDeviation(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.MinAggregate? GetMin(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.MinAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.MissingAggregate? GetMissing(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.MissingAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregate? GetMultiTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.NestedAggregate? GetNested(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.NestedAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ParentAggregate? GetParent(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ParentAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregate? GetPercentilesBucket(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregate? GetRange(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.RangeAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.RateAggregate? GetRate(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.RateAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregate? GetReverseNested(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregate? GetSampler(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregate? GetScriptedMetric(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.SignificantLongTermsAggregate? GetSignificantLongTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.SignificantLongTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.SignificantStringTermsAggregate? GetSignificantStringTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.SignificantStringTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregate? GetCumulativeCardinality(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.SimpleValueAggregate? GetSimpleValue(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.SimpleValueAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.StringRareTermsAggregate? GetStringRareTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.StringRareTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.StatsAggregate? GetStats(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.StatsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregate? GetStatsBucket(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.StringTermsAggregate? GetStringTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.StringTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregate? GetStringStats(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.SumAggregate? GetSum(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.SumAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregate? GetTTest(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.TTestAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentileRanksAggregate? GetTDigestPercentileRanks(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentileRanksAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentilesAggregate? GetTDigestPercentiles(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentilesAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregate? GetTimeSeries(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregate? GetTopHits(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregate? GetTopMetrics(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.UnmappedRareTermsAggregate? GetUnmappedRareTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.UnmappedRareTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.UnmappedSignificantTermsAggregate? GetUnmappedSignificantTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.UnmappedSignificantTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.UnmappedTermsAggregate? GetUnmappedTerms(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.UnmappedTermsAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.UnmappedSamplerAggregate? GetUnmappedSampler(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.UnmappedSamplerAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregate? GetValueCount(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregate? GetVariableWidthHistogram(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregate>(key);
	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregate? GetWeightedAverage(string key) => TryGet<Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregate>(key);
	private T? TryGet<T>(string key) where T : class, IAggregate => BackingDictionary.TryGetValue(Sanitize(key), out var value) ? value as T : null;
}