// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class AggregateDictionaryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.AggregateDictionary>
{
	public override Elastic.Clients.Elasticsearch.Aggregations.AggregateDictionary Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		var dictionary = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.IAggregate>();
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			ReadItem(ref reader, options, out string name, out Elastic.Clients.Elasticsearch.Aggregations.IAggregate value);
			dictionary[name] = value;
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Aggregations.AggregateDictionary(dictionary);
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.AggregateDictionary value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		foreach (var pair in value)
		{
			WriteItem(writer, options, pair.Key, pair.Value);
		}

		writer.WriteEndObject();
	}

	internal static void ReadItem(ref System.Text.Json.Utf8JsonReader reader, System.Text.Json.JsonSerializerOptions options, out string name, out Elastic.Clients.Elasticsearch.Aggregations.IAggregate value)
	{
		var key = reader.ReadPropertyName<string>(options, static string (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadPropertyName<string>(o)!);
		reader.Read();
		var parts = key.Split('#');
		if (parts.Length != 2)
		{
			throw new System.Text.Json.JsonException($"Unable to parse typed-key '{key}' for variant '{nameof(Elastic.Clients.Elasticsearch.Aggregations.IAggregate)}'.");
		}

		var discriminator = parts[0];
		name = parts[1];
		value = discriminator switch
		{
			"adjacency_matrix" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregate>(options, null),
			"auto_date_histogram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregate>(options, null),
			"avg" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.AverageAggregate>(options, null),
			"boxplot" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregate>(options, null),
			"bucket_metric_value" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.BucketMetricValueAggregate>(options, null),
			"cardinality" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregate>(options, null),
			"cartesian_bounds" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregate>(options, null),
			"cartesian_centroid" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregate>(options, null),
			"change_point" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregate>(options, null),
			"children" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregate>(options, null),
			"composite" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregate>(options, null),
			"date_histogram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregate>(options, null),
			"date_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregate>(options, null),
			"derivative" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregate>(options, null),
			"dterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DoubleTermsAggregate>(options, null),
			"extended_stats" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregate>(options, null),
			"extended_stats_bucket" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate>(options, null),
			"filter" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.FilterAggregate>(options, null),
			"filters" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregate>(options, null),
			"frequent_item_sets" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregate>(options, null),
			"geo_bounds" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregate>(options, null),
			"geo_centroid" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregate>(options, null),
			"geo_distance" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregate>(options, null),
			"geo_line" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregate>(options, null),
			"geohash_grid" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregate>(options, null),
			"geohex_grid" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregate>(options, null),
			"geotile_grid" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregate>(options, null),
			"global" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregate>(options, null),
			"hdr_percentile_ranks" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.HdrPercentileRanksAggregate>(options, null),
			"hdr_percentiles" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.HdrPercentilesAggregate>(options, null),
			"histogram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregate>(options, null),
			"inference" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregate>(options, null),
			"ip_prefix" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregate>(options, null),
			"ip_range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregate>(options, null),
			"lrareterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.LongRareTermsAggregate>(options, null),
			"lterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.LongTermsAggregate>(options, null),
			"matrix_stats" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregate>(options, null),
			"max" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MaxAggregate>(options, null),
			"median_absolute_deviation" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregate>(options, null),
			"min" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MinAggregate>(options, null),
			"missing" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MissingAggregate>(options, null),
			"multi_terms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregate>(options, null),
			"nested" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.NestedAggregate>(options, null),
			"parent" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ParentAggregate>(options, null),
			"percentiles_bucket" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregate>(options, null),
			"range" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.RangeAggregate>(options, null),
			"rate" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.RateAggregate>(options, null),
			"reverse_nested" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregate>(options, null),
			"sampler" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregate>(options, null),
			"scripted_metric" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregate>(options, null),
			"siglterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SignificantLongTermsAggregate>(options, null),
			"sigsterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SignificantStringTermsAggregate>(options, null),
			"simple_long_value" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregate>(options, null),
			"simple_value" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SimpleValueAggregate>(options, null),
			"srareterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StringRareTermsAggregate>(options, null),
			"stats" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StatsAggregate>(options, null),
			"stats_bucket" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregate>(options, null),
			"sterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StringTermsAggregate>(options, null),
			"string_stats" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregate>(options, null),
			"sum" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.SumAggregate>(options, null),
			"t_test" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TTestAggregate>(options, null),
			"tdigest_percentile_ranks" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentileRanksAggregate>(options, null),
			"tdigest_percentiles" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentilesAggregate>(options, null),
			"time_series" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregate>(options, null),
			"top_hits" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregate>(options, null),
			"top_metrics" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregate>(options, null),
			"umrareterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.UnmappedRareTermsAggregate>(options, null),
			"umsigterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.UnmappedSignificantTermsAggregate>(options, null),
			"umterms" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.UnmappedTermsAggregate>(options, null),
			"unmapped_sampler" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.UnmappedSamplerAggregate>(options, null),
			"value_count" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregate>(options, null),
			"variable_width_histogram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregate>(options, null),
			"weighted_avg" => reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregate>(options, null),
			_ => throw new System.Text.Json.JsonException($"Variant '{discriminator}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Aggregations.IAggregate)}'.")
		};
	}

	internal static void WriteItem(System.Text.Json.Utf8JsonWriter writer, System.Text.Json.JsonSerializerOptions options, string name, Elastic.Clients.Elasticsearch.Aggregations.IAggregate value)
	{
		var key = value.Type + '#' + name;
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.AdjacencyMatrixAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.AutoDateHistogramAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.AverageAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.AverageAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.AverageAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.BoxplotAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.BucketMetricValueAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.BucketMetricValueAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.BucketMetricValueAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.CartesianBoundsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.CartesianCentroidAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ChangePointAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ChildrenAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.DateHistogramAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.DerivativeAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.DoubleTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.DoubleTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.DoubleTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ExtendedStatsBucketAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.FilterAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.FilterAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.FilterAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.FiltersAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.FrequentItemSetsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GeoBoundsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GeoCentroidAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GeoDistanceAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GeoLineAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GeohashGridAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GeohexGridAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GeotileGridAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.GlobalAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.HdrPercentileRanksAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.HdrPercentileRanksAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.HdrPercentileRanksAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.HdrPercentilesAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.HdrPercentilesAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.HdrPercentilesAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.HistogramAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.InferenceAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.IpPrefixAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.LongRareTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.LongRareTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.LongRareTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.LongTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.LongTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.LongTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MaxAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.MaxAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.MaxAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.MedianAbsoluteDeviationAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MinAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.MinAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.MinAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MissingAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.MissingAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.MissingAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.NestedAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.NestedAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.NestedAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ParentAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ParentAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ParentAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.PercentilesBucketAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.RangeAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.RangeAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.RangeAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.RateAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.RateAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.RateAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ReverseNestedAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.SignificantLongTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.SignificantLongTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.SignificantLongTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.SignificantStringTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.SignificantStringTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.SignificantStringTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.CumulativeCardinalityAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.SimpleValueAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.SimpleValueAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.SimpleValueAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.StringRareTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.StringRareTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.StringRareTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.StatsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.StatsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.StatsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.StatsBucketAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.StringTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.StringTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.StringTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.StringStatsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.SumAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.SumAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.SumAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TTestAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.TTestAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.TTestAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentileRanksAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentileRanksAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentileRanksAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentilesAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentilesAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.TDigestPercentilesAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.TopHitsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.UnmappedRareTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.UnmappedRareTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.UnmappedRareTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.UnmappedSignificantTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.UnmappedSignificantTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.UnmappedSignificantTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.UnmappedTermsAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.UnmappedTermsAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.UnmappedTermsAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.UnmappedSamplerAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.UnmappedSamplerAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.UnmappedSamplerAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregate>(o, v));
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregate v:
				writer.WriteProperty(options, key, v, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregate v) => w.WritePropertyName<Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageAggregate>(o, v));
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{0}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Aggregations.IAggregate)}'.");
		}
	}
}