// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

public partial class TransformManagementNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.TransformManagement.TransformManagementNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected TransformManagementNamespacedClient() : base()
	{
	}

	internal TransformManagementNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse DeleteTransform(Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse DeleteTransform(Elastic.Clients.Elasticsearch.Id transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse DeleteTransform(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse> DeleteTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse> DeleteTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse> DeleteTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.DeleteTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse GetTransform(Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse GetTransform()
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse GetTransform(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse GetTransform(Elastic.Clients.Elasticsearch.Names? transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse GetTransform(Elastic.Clients.Elasticsearch.Names? transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse> GetTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse> GetTransformAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse> GetTransformAsync(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse> GetTransformAsync(Elastic.Clients.Elasticsearch.Names? transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse> GetTransformAsync(Elastic.Clients.Elasticsearch.Names? transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse GetTransformStats(Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse GetTransformStats(Elastic.Clients.Elasticsearch.Names transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse GetTransformStats(Elastic.Clients.Elasticsearch.Names transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse> GetTransformStatsAsync(Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse> GetTransformStatsAsync(Elastic.Clients.Elasticsearch.Names transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse> GetTransformStatsAsync(Elastic.Clients.Elasticsearch.Names transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequest, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsResponse, Elastic.Clients.Elasticsearch.TransformManagement.GetTransformStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform> PreviewTransform<TTransform>(Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform> PreviewTransform<TDocument, TTransform>()
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform> PreviewTransform<TDocument, TTransform>(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform> PreviewTransform<TDocument, TTransform>(Elastic.Clients.Elasticsearch.Id? transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform> PreviewTransform<TDocument, TTransform>(Elastic.Clients.Elasticsearch.Id? transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>> PreviewTransformAsync<TTransform>(Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>> PreviewTransformAsync<TDocument, TTransform>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>> PreviewTransformAsync<TDocument, TTransform>(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>> PreviewTransformAsync<TDocument, TTransform>(Elastic.Clients.Elasticsearch.Id? transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>> PreviewTransformAsync<TDocument, TTransform>(Elastic.Clients.Elasticsearch.Id? transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestDescriptor<TDocument>(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformResponse<TTransform>, Elastic.Clients.Elasticsearch.TransformManagement.PreviewTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse PutTransform(Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse PutTransform(Elastic.Clients.Elasticsearch.Id transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse PutTransform(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse PutTransform<TDocument>(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor<TDocument>(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse> PutTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse> PutTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse> PutTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse> PutTransformAsync<TDocument>(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestDescriptor<TDocument>(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.PutTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse ResetTransform(Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse ResetTransform(Elastic.Clients.Elasticsearch.Id transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse ResetTransform(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse> ResetTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse> ResetTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse> ResetTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ResetTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse ScheduleNowTransform(Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse ScheduleNowTransform(Elastic.Clients.Elasticsearch.Id transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse ScheduleNowTransform(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse> ScheduleNowTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse> ScheduleNowTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse> ScheduleNowTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.ScheduleNowTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse SetUpgradeMode(Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse SetUpgradeMode()
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse SetUpgradeMode(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse> SetUpgradeModeAsync(Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse> SetUpgradeModeAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse> SetUpgradeModeAsync(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse StartTransform(Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse StartTransform(Elastic.Clients.Elasticsearch.Id transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse StartTransform(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse> StartTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse> StartTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse> StartTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse StopTransform(Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse StopTransform(Elastic.Clients.Elasticsearch.Name transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse StopTransform(Elastic.Clients.Elasticsearch.Name transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse> StopTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse> StopTransformAsync(Elastic.Clients.Elasticsearch.Name transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse> StopTransformAsync(Elastic.Clients.Elasticsearch.Name transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.StopTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse UpdateTransform(Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse UpdateTransform(Elastic.Clients.Elasticsearch.Id transformId)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse UpdateTransform(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse UpdateTransform<TDocument>(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor<TDocument>(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse> UpdateTransformAsync(Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse> UpdateTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor(transformId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse> UpdateTransformAsync(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse> UpdateTransformAsync<TDocument>(Elastic.Clients.Elasticsearch.Id transformId, System.Action<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestDescriptor<TDocument>(transformId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpdateTransformRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse UpgradeTransforms(Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse UpgradeTransforms()
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse UpgradeTransforms(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse> UpgradeTransformsAsync(Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse> UpgradeTransformsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse> UpgradeTransformsAsync(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequest, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsRequestParameters>(request, cancellationToken);
	}
}