// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

public partial class SnapshotNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.Snapshot.SnapshotNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected SnapshotNamespacedClient() : base()
	{
	}

	internal SnapshotNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse CleanupRepository(Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse CleanupRepository(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse CleanupRepository(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse> CleanupRepositoryAsync(Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse> CleanupRepositoryAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse> CleanupRepositoryAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CleanupRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse Clone(Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse Clone(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, Elastic.Clients.Elasticsearch.Name targetSnapshot)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestDescriptor(repository, snapshot, targetSnapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse Clone(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, Elastic.Clients.Elasticsearch.Name targetSnapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestDescriptor(repository, snapshot, targetSnapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse> CloneAsync(Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse> CloneAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, Elastic.Clients.Elasticsearch.Name targetSnapshot, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestDescriptor(repository, snapshot, targetSnapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse> CloneAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, Elastic.Clients.Elasticsearch.Name targetSnapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestDescriptor(repository, snapshot, targetSnapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CloneSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse Create(Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse Create(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse Create(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse> CreateAsync(Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse> CreateAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse> CreateAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse CreateRepository(Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse CreateRepository(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse CreateRepository(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse> CreateRepositoryAsync(Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse> CreateRepositoryAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse> CreateRepositoryAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse Delete(Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse Delete(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse Delete(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse> DeleteAsync(Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse> DeleteAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse> DeleteAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse DeleteRepository(Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse DeleteRepository(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse DeleteRepository(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse> DeleteRepositoryAsync(Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse> DeleteRepositoryAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse> DeleteRepositoryAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.DeleteRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse Get(Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse Get(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Names snapshot)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse Get(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Names snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse> GetAsync(Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse> GetAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Names snapshot, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse> GetAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Names snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequest, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotResponse, Elastic.Clients.Elasticsearch.Snapshot.GetSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse GetRepository(Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse GetRepository()
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse GetRepository(System.Action<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse GetRepository(Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse GetRepository(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse> GetRepositoryAsync(Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse> GetRepositoryAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse> GetRepositoryAsync(System.Action<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse> GetRepositoryAsync(Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse> GetRepositoryAsync(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.GetRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse RepositoryAnalyze(Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse RepositoryAnalyze(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse RepositoryAnalyze(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse> RepositoryAnalyzeAsync(Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse> RepositoryAnalyzeAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse> RepositoryAnalyzeAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse RepositoryVerifyIntegrity(Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse RepositoryVerifyIntegrity(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse RepositoryVerifyIntegrity(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse> RepositoryVerifyIntegrityAsync(Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse> RepositoryVerifyIntegrityAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse> RepositoryVerifyIntegrityAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequest, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityResponse, Elastic.Clients.Elasticsearch.Snapshot.RepositoryVerifyIntegrityRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse Restore(Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse Restore(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse Restore(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse Restore<TDocument>(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor<TDocument>(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse> RestoreAsync(Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse> RestoreAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse> RestoreAsync(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse> RestoreAsync<TDocument>(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestDescriptor<TDocument>(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.RestoreRequest, Elastic.Clients.Elasticsearch.Snapshot.RestoreResponse, Elastic.Clients.Elasticsearch.Snapshot.RestoreRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse Status(Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse Status()
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse Status(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse Status(Elastic.Clients.Elasticsearch.Name? repository)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse Status(Elastic.Clients.Elasticsearch.Name? repository, System.Action<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse Status(Elastic.Clients.Elasticsearch.Name? repository, Elastic.Clients.Elasticsearch.Names? snapshot)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse Status(Elastic.Clients.Elasticsearch.Name? repository, Elastic.Clients.Elasticsearch.Names? snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse> StatusAsync(Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse> StatusAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse> StatusAsync(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse> StatusAsync(Elastic.Clients.Elasticsearch.Name? repository, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse> StatusAsync(Elastic.Clients.Elasticsearch.Name? repository, System.Action<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse> StatusAsync(Elastic.Clients.Elasticsearch.Name? repository, Elastic.Clients.Elasticsearch.Names? snapshot, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository, snapshot);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse> StatusAsync(Elastic.Clients.Elasticsearch.Name? repository, Elastic.Clients.Elasticsearch.Names? snapshot, System.Action<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(repository, snapshot);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusResponse, Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse VerifyRepository(Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse VerifyRepository(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse VerifyRepository(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse> VerifyRepositoryAsync(Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse> VerifyRepositoryAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse> VerifyRepositoryAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequest, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryResponse, Elastic.Clients.Elasticsearch.Snapshot.VerifyRepositoryRequestParameters>(request, cancellationToken);
	}
}