// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public partial class SecurityNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.Security.SecurityNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected SecurityNamespacedClient() : base()
	{
	}

	internal SecurityNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse ActivateUserProfile(Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse ActivateUserProfile(System.Action<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse> ActivateUserProfileAsync(Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse> ActivateUserProfileAsync(System.Action<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileResponse, Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.AuthenticateResponse Authenticate(Elastic.Clients.Elasticsearch.Security.AuthenticateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.AuthenticateRequest, Elastic.Clients.Elasticsearch.Security.AuthenticateResponse, Elastic.Clients.Elasticsearch.Security.AuthenticateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.AuthenticateResponse Authenticate()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.AuthenticateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.AuthenticateRequest, Elastic.Clients.Elasticsearch.Security.AuthenticateResponse, Elastic.Clients.Elasticsearch.Security.AuthenticateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.AuthenticateResponse Authenticate(System.Action<Elastic.Clients.Elasticsearch.Security.AuthenticateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.AuthenticateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.AuthenticateRequest, Elastic.Clients.Elasticsearch.Security.AuthenticateResponse, Elastic.Clients.Elasticsearch.Security.AuthenticateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.AuthenticateResponse> AuthenticateAsync(Elastic.Clients.Elasticsearch.Security.AuthenticateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.AuthenticateRequest, Elastic.Clients.Elasticsearch.Security.AuthenticateResponse, Elastic.Clients.Elasticsearch.Security.AuthenticateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.AuthenticateResponse> AuthenticateAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.AuthenticateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.AuthenticateRequest, Elastic.Clients.Elasticsearch.Security.AuthenticateResponse, Elastic.Clients.Elasticsearch.Security.AuthenticateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.AuthenticateResponse> AuthenticateAsync(System.Action<Elastic.Clients.Elasticsearch.Security.AuthenticateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.AuthenticateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.AuthenticateRequest, Elastic.Clients.Elasticsearch.Security.AuthenticateResponse, Elastic.Clients.Elasticsearch.Security.AuthenticateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse BulkDeleteRole(Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse BulkDeleteRole(System.Action<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse> BulkDeleteRoleAsync(Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse> BulkDeleteRoleAsync(System.Action<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse BulkPutRole(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse BulkPutRole(System.Action<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse BulkPutRole<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse> BulkPutRoleAsync(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse> BulkPutRoleAsync(System.Action<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse> BulkPutRoleAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest, Elastic.Clients.Elasticsearch.Security.BulkPutRoleResponse, Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse BulkUpdateApiKeys(Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse BulkUpdateApiKeys(System.Action<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse BulkUpdateApiKeys<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse> BulkUpdateApiKeysAsync(Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse> BulkUpdateApiKeysAsync(System.Action<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse> BulkUpdateApiKeysAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequest, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysResponse, Elastic.Clients.Elasticsearch.Security.BulkUpdateApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse ChangePassword(Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse ChangePassword()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse ChangePassword(System.Action<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse ChangePassword(Elastic.Clients.Elasticsearch.Username? username)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse ChangePassword(Elastic.Clients.Elasticsearch.Username? username, System.Action<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse> ChangePasswordAsync(Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse> ChangePasswordAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse> ChangePasswordAsync(System.Action<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse> ChangePasswordAsync(Elastic.Clients.Elasticsearch.Username? username, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse> ChangePasswordAsync(Elastic.Clients.Elasticsearch.Username? username, System.Action<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ChangePasswordRequest, Elastic.Clients.Elasticsearch.Security.ChangePasswordResponse, Elastic.Clients.Elasticsearch.Security.ChangePasswordRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse ClearApiKeyCache(Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse ClearApiKeyCache(Elastic.Clients.Elasticsearch.Ids ids)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestDescriptor(ids);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse ClearApiKeyCache(Elastic.Clients.Elasticsearch.Ids ids, System.Action<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestDescriptor(ids);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse> ClearApiKeyCacheAsync(Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse> ClearApiKeyCacheAsync(Elastic.Clients.Elasticsearch.Ids ids, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestDescriptor(ids);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse> ClearApiKeyCacheAsync(Elastic.Clients.Elasticsearch.Ids ids, System.Action<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestDescriptor(ids);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequest, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheResponse, Elastic.Clients.Elasticsearch.Security.ClearApiKeyCacheRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse ClearCachedPrivileges(Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse ClearCachedPrivileges(Elastic.Clients.Elasticsearch.Name application)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor(application);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse ClearCachedPrivileges(Elastic.Clients.Elasticsearch.Name application, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor(application);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse> ClearCachedPrivilegesAsync(Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse> ClearCachedPrivilegesAsync(Elastic.Clients.Elasticsearch.Name application, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor(application);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse> ClearCachedPrivilegesAsync(Elastic.Clients.Elasticsearch.Name application, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor(application);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse ClearCachedRealms(Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse ClearCachedRealms(Elastic.Clients.Elasticsearch.Names realms)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor(realms);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse ClearCachedRealms(Elastic.Clients.Elasticsearch.Names realms, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor(realms);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse> ClearCachedRealmsAsync(Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse> ClearCachedRealmsAsync(Elastic.Clients.Elasticsearch.Names realms, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor(realms);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse> ClearCachedRealmsAsync(Elastic.Clients.Elasticsearch.Names realms, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor(realms);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse ClearCachedRoles(Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse ClearCachedRoles(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse ClearCachedRoles(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse> ClearCachedRolesAsync(Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse> ClearCachedRolesAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse> ClearCachedRolesAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse ClearCachedServiceTokens(Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse ClearCachedServiceTokens(string @namespace, string service, Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor(@namespace, service, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse ClearCachedServiceTokens(string @namespace, string service, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor(@namespace, service, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse> ClearCachedServiceTokensAsync(Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse> ClearCachedServiceTokensAsync(string @namespace, string service, Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor(@namespace, service, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse> ClearCachedServiceTokensAsync(string @namespace, string service, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor(@namespace, service, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensResponse, Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse CreateApiKey(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse CreateApiKey()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse CreateApiKey(System.Action<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse CreateApiKey<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse CreateApiKey<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse> CreateApiKeyAsync(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse> CreateApiKeyAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse> CreateApiKeyAsync(System.Action<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse> CreateApiKeyAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse> CreateApiKeyAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse CreateCrossClusterApiKey(Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse CreateCrossClusterApiKey(System.Action<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse CreateCrossClusterApiKey<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse> CreateCrossClusterApiKeyAsync(Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse> CreateCrossClusterApiKeyAsync(System.Action<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse> CreateCrossClusterApiKeyAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.CreateCrossClusterApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse CreateServiceToken(Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse CreateServiceToken(string @namespace, string service, Elastic.Clients.Elasticsearch.Name? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse CreateServiceToken(string @namespace, string service, Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse CreateServiceToken(string @namespace, string service)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse CreateServiceToken(string @namespace, string service, System.Action<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse> CreateServiceTokenAsync(Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse> CreateServiceTokenAsync(string @namespace, string service, Elastic.Clients.Elasticsearch.Name? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse> CreateServiceTokenAsync(string @namespace, string service, Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse> CreateServiceTokenAsync(string @namespace, string service, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse> CreateServiceTokenAsync(string @namespace, string service, System.Action<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestDescriptor(@namespace, service);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.CreateServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse DelegatePki(Elastic.Clients.Elasticsearch.Security.DelegatePkiRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DelegatePkiRequest, Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse, Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse DelegatePki(System.Action<Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DelegatePkiRequest, Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse, Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse> DelegatePkiAsync(Elastic.Clients.Elasticsearch.Security.DelegatePkiRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DelegatePkiRequest, Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse, Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse> DelegatePkiAsync(System.Action<Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DelegatePkiRequest, Elastic.Clients.Elasticsearch.Security.DelegatePkiResponse, Elastic.Clients.Elasticsearch.Security.DelegatePkiRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse DeletePrivileges(Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse DeletePrivileges(Elastic.Clients.Elasticsearch.Name application, Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestDescriptor(application, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse DeletePrivileges(Elastic.Clients.Elasticsearch.Name application, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestDescriptor(application, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse> DeletePrivilegesAsync(Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse> DeletePrivilegesAsync(Elastic.Clients.Elasticsearch.Name application, Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestDescriptor(application, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse> DeletePrivilegesAsync(Elastic.Clients.Elasticsearch.Name application, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestDescriptor(application, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequest, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesResponse, Elastic.Clients.Elasticsearch.Security.DeletePrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse DeleteRole(Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse DeleteRole(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse DeleteRole(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse> DeleteRoleAsync(Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse> DeleteRoleAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse> DeleteRoleAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteRoleRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse DeleteRoleMapping(Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse DeleteRoleMapping(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse DeleteRoleMapping(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse> DeleteRoleMappingAsync(Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse> DeleteRoleMappingAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse> DeleteRoleMappingAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.DeleteRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse DeleteServiceToken(Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse DeleteServiceToken(string @namespace, string service, Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestDescriptor(@namespace, service, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse DeleteServiceToken(string @namespace, string service, Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestDescriptor(@namespace, service, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse> DeleteServiceTokenAsync(Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse> DeleteServiceTokenAsync(string @namespace, string service, Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestDescriptor(@namespace, service, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse> DeleteServiceTokenAsync(string @namespace, string service, Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestDescriptor(@namespace, service, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequest, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenResponse, Elastic.Clients.Elasticsearch.Security.DeleteServiceTokenRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteUserResponse DeleteUser(Elastic.Clients.Elasticsearch.Security.DeleteUserRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteUserRequest, Elastic.Clients.Elasticsearch.Security.DeleteUserResponse, Elastic.Clients.Elasticsearch.Security.DeleteUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteUserResponse DeleteUser(Elastic.Clients.Elasticsearch.Username username)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteUserRequest, Elastic.Clients.Elasticsearch.Security.DeleteUserResponse, Elastic.Clients.Elasticsearch.Security.DeleteUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DeleteUserResponse DeleteUser(Elastic.Clients.Elasticsearch.Username username, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteUserRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DeleteUserRequest, Elastic.Clients.Elasticsearch.Security.DeleteUserResponse, Elastic.Clients.Elasticsearch.Security.DeleteUserRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteUserResponse> DeleteUserAsync(Elastic.Clients.Elasticsearch.Security.DeleteUserRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteUserRequest, Elastic.Clients.Elasticsearch.Security.DeleteUserResponse, Elastic.Clients.Elasticsearch.Security.DeleteUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteUserResponse> DeleteUserAsync(Elastic.Clients.Elasticsearch.Username username, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteUserRequest, Elastic.Clients.Elasticsearch.Security.DeleteUserResponse, Elastic.Clients.Elasticsearch.Security.DeleteUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DeleteUserResponse> DeleteUserAsync(Elastic.Clients.Elasticsearch.Username username, System.Action<Elastic.Clients.Elasticsearch.Security.DeleteUserRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DeleteUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DeleteUserRequest, Elastic.Clients.Elasticsearch.Security.DeleteUserResponse, Elastic.Clients.Elasticsearch.Security.DeleteUserRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DisableUserResponse DisableUser(Elastic.Clients.Elasticsearch.Security.DisableUserRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DisableUserRequest, Elastic.Clients.Elasticsearch.Security.DisableUserResponse, Elastic.Clients.Elasticsearch.Security.DisableUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DisableUserResponse DisableUser(Elastic.Clients.Elasticsearch.Username username)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DisableUserRequest, Elastic.Clients.Elasticsearch.Security.DisableUserResponse, Elastic.Clients.Elasticsearch.Security.DisableUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DisableUserResponse DisableUser(Elastic.Clients.Elasticsearch.Username username, System.Action<Elastic.Clients.Elasticsearch.Security.DisableUserRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DisableUserRequest, Elastic.Clients.Elasticsearch.Security.DisableUserResponse, Elastic.Clients.Elasticsearch.Security.DisableUserRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DisableUserResponse> DisableUserAsync(Elastic.Clients.Elasticsearch.Security.DisableUserRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DisableUserRequest, Elastic.Clients.Elasticsearch.Security.DisableUserResponse, Elastic.Clients.Elasticsearch.Security.DisableUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DisableUserResponse> DisableUserAsync(Elastic.Clients.Elasticsearch.Username username, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DisableUserRequest, Elastic.Clients.Elasticsearch.Security.DisableUserResponse, Elastic.Clients.Elasticsearch.Security.DisableUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DisableUserResponse> DisableUserAsync(Elastic.Clients.Elasticsearch.Username username, System.Action<Elastic.Clients.Elasticsearch.Security.DisableUserRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DisableUserRequest, Elastic.Clients.Elasticsearch.Security.DisableUserResponse, Elastic.Clients.Elasticsearch.Security.DisableUserRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse DisableUserProfile(Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse DisableUserProfile(string uid)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse DisableUserProfile(string uid, System.Action<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse> DisableUserProfileAsync(Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse> DisableUserProfileAsync(string uid, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse> DisableUserProfileAsync(string uid, System.Action<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.DisableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.DisableUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnableUserResponse EnableUser(Elastic.Clients.Elasticsearch.Security.EnableUserRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnableUserRequest, Elastic.Clients.Elasticsearch.Security.EnableUserResponse, Elastic.Clients.Elasticsearch.Security.EnableUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnableUserResponse EnableUser(Elastic.Clients.Elasticsearch.Username username)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnableUserRequest, Elastic.Clients.Elasticsearch.Security.EnableUserResponse, Elastic.Clients.Elasticsearch.Security.EnableUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnableUserResponse EnableUser(Elastic.Clients.Elasticsearch.Username username, System.Action<Elastic.Clients.Elasticsearch.Security.EnableUserRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnableUserRequest, Elastic.Clients.Elasticsearch.Security.EnableUserResponse, Elastic.Clients.Elasticsearch.Security.EnableUserRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnableUserResponse> EnableUserAsync(Elastic.Clients.Elasticsearch.Security.EnableUserRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnableUserRequest, Elastic.Clients.Elasticsearch.Security.EnableUserResponse, Elastic.Clients.Elasticsearch.Security.EnableUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnableUserResponse> EnableUserAsync(Elastic.Clients.Elasticsearch.Username username, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnableUserRequest, Elastic.Clients.Elasticsearch.Security.EnableUserResponse, Elastic.Clients.Elasticsearch.Security.EnableUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnableUserResponse> EnableUserAsync(Elastic.Clients.Elasticsearch.Username username, System.Action<Elastic.Clients.Elasticsearch.Security.EnableUserRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnableUserRequest, Elastic.Clients.Elasticsearch.Security.EnableUserResponse, Elastic.Clients.Elasticsearch.Security.EnableUserRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse EnableUserProfile(Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse EnableUserProfile(string uid)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse EnableUserProfile(string uid, System.Action<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse> EnableUserProfileAsync(Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse> EnableUserProfileAsync(string uid, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse> EnableUserProfileAsync(string uid, System.Action<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequest, Elastic.Clients.Elasticsearch.Security.EnableUserProfileResponse, Elastic.Clients.Elasticsearch.Security.EnableUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse EnrollKibana(Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest, Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse, Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse EnrollKibana()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest, Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse, Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse EnrollKibana(System.Action<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest, Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse, Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse> EnrollKibanaAsync(Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest, Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse, Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse> EnrollKibanaAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest, Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse, Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse> EnrollKibanaAsync(System.Action<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequest, Elastic.Clients.Elasticsearch.Security.EnrollKibanaResponse, Elastic.Clients.Elasticsearch.Security.EnrollKibanaRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse EnrollNode(Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest, Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse, Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse EnrollNode()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest, Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse, Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse EnrollNode(System.Action<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest, Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse, Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse> EnrollNodeAsync(Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest, Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse, Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse> EnrollNodeAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest, Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse, Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse> EnrollNodeAsync(System.Action<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest, Elastic.Clients.Elasticsearch.Security.EnrollNodeResponse, Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse GetApiKey(Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse GetApiKey()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse GetApiKey(System.Action<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse> GetApiKeyAsync(Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse> GetApiKeyAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse> GetApiKeyAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GetApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GetApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse GetBuiltinPrivileges(Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse GetBuiltinPrivileges()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse GetBuiltinPrivileges(System.Action<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse> GetBuiltinPrivilegesAsync(Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse> GetBuiltinPrivilegesAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse> GetBuiltinPrivilegesAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetBuiltinPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse GetPrivileges(Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse GetPrivileges()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse GetPrivileges(System.Action<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse GetPrivileges(Elastic.Clients.Elasticsearch.Name? application)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse GetPrivileges(Elastic.Clients.Elasticsearch.Name? application, System.Action<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse GetPrivileges(Elastic.Clients.Elasticsearch.Name? application, Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse GetPrivileges(Elastic.Clients.Elasticsearch.Name? application, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse> GetPrivilegesAsync(Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse> GetPrivilegesAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse> GetPrivilegesAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse> GetPrivilegesAsync(Elastic.Clients.Elasticsearch.Name? application, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse> GetPrivilegesAsync(Elastic.Clients.Elasticsearch.Name? application, System.Action<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse> GetPrivilegesAsync(Elastic.Clients.Elasticsearch.Name? application, Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse> GetPrivilegesAsync(Elastic.Clients.Elasticsearch.Name? application, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestDescriptor(application, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleResponse GetRole(Elastic.Clients.Elasticsearch.Security.GetRoleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleResponse GetRole()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleResponse GetRole(System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleResponse GetRole(Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleResponse GetRole(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleResponse> GetRoleAsync(Elastic.Clients.Elasticsearch.Security.GetRoleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleResponse> GetRoleAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleResponse> GetRoleAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleResponse> GetRoleAsync(Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleResponse> GetRoleAsync(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleRequest, Elastic.Clients.Elasticsearch.Security.GetRoleResponse, Elastic.Clients.Elasticsearch.Security.GetRoleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse GetRoleMapping(Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse GetRoleMapping()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse GetRoleMapping(System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse GetRoleMapping(Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse GetRoleMapping(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse> GetRoleMappingAsync(Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse> GetRoleMappingAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse> GetRoleMappingAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse> GetRoleMappingAsync(Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse> GetRoleMappingAsync(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.GetRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.GetRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse GetServiceAccounts(Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse GetServiceAccounts()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse GetServiceAccounts(System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse GetServiceAccounts(string? @namespace, string? service)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace, service);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse GetServiceAccounts(string? @namespace, string? service, System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace, service);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse GetServiceAccounts(string? @namespace)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse GetServiceAccounts(string? @namespace, System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse> GetServiceAccountsAsync(Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse> GetServiceAccountsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse> GetServiceAccountsAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse> GetServiceAccountsAsync(string? @namespace, string? service, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace, service);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse> GetServiceAccountsAsync(string? @namespace, string? service, System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace, service);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse> GetServiceAccountsAsync(string? @namespace, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse> GetServiceAccountsAsync(string? @namespace, System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(@namespace);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse GetServiceCredentials(Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse GetServiceCredentials(string @namespace, Elastic.Clients.Elasticsearch.Name service)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor(@namespace, service);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse GetServiceCredentials(string @namespace, Elastic.Clients.Elasticsearch.Name service, System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor(@namespace, service);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse> GetServiceCredentialsAsync(Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse> GetServiceCredentialsAsync(string @namespace, Elastic.Clients.Elasticsearch.Name service, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor(@namespace, service);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse> GetServiceCredentialsAsync(string @namespace, Elastic.Clients.Elasticsearch.Name service, System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor(@namespace, service);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsResponse, Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse GetSettings()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse GetSettings(System.Action<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse> GetSettingsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse> GetSettingsAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequest, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsResponse, Elastic.Clients.Elasticsearch.Security.GetSecuritySettingsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetTokenResponse GetToken(Elastic.Clients.Elasticsearch.Security.GetTokenRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetTokenRequest, Elastic.Clients.Elasticsearch.Security.GetTokenResponse, Elastic.Clients.Elasticsearch.Security.GetTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetTokenResponse GetToken()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetTokenRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetTokenRequest, Elastic.Clients.Elasticsearch.Security.GetTokenResponse, Elastic.Clients.Elasticsearch.Security.GetTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetTokenResponse GetToken(System.Action<Elastic.Clients.Elasticsearch.Security.GetTokenRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetTokenRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetTokenRequest, Elastic.Clients.Elasticsearch.Security.GetTokenResponse, Elastic.Clients.Elasticsearch.Security.GetTokenRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetTokenResponse> GetTokenAsync(Elastic.Clients.Elasticsearch.Security.GetTokenRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetTokenRequest, Elastic.Clients.Elasticsearch.Security.GetTokenResponse, Elastic.Clients.Elasticsearch.Security.GetTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetTokenResponse> GetTokenAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetTokenRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetTokenRequest, Elastic.Clients.Elasticsearch.Security.GetTokenResponse, Elastic.Clients.Elasticsearch.Security.GetTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetTokenResponse> GetTokenAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetTokenRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetTokenRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetTokenRequest, Elastic.Clients.Elasticsearch.Security.GetTokenResponse, Elastic.Clients.Elasticsearch.Security.GetTokenRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserResponse GetUser(Elastic.Clients.Elasticsearch.Security.GetUserRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserResponse GetUser()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserResponse GetUser(System.Action<Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserResponse GetUser(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? username)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserResponse GetUser(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? username, System.Action<Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserResponse> GetUserAsync(Elastic.Clients.Elasticsearch.Security.GetUserRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserResponse> GetUserAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserResponse> GetUserAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserResponse> GetUserAsync(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? username, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor(username);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserResponse> GetUserAsync(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? username, System.Action<Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor(username);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserRequest, Elastic.Clients.Elasticsearch.Security.GetUserResponse, Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse GetUserPrivileges(Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse GetUserPrivileges()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse GetUserPrivileges(System.Action<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse> GetUserPrivilegesAsync(Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse> GetUserPrivilegesAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse> GetUserPrivilegesAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.GetUserPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse GetUserProfile(Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest, Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse, Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse GetUserProfile(System.Collections.Generic.ICollection<string> uid)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest, Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse, Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse GetUserProfile(System.Collections.Generic.ICollection<string> uid, System.Action<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest, Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse, Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse> GetUserProfileAsync(Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest, Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse, Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse> GetUserProfileAsync(System.Collections.Generic.ICollection<string> uid, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest, Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse, Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse> GetUserProfileAsync(System.Collections.Generic.ICollection<string> uid, System.Action<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GetUserProfileRequest, Elastic.Clients.Elasticsearch.Security.GetUserProfileResponse, Elastic.Clients.Elasticsearch.Security.GetUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse GrantApiKey(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse GrantApiKey(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse GrantApiKey<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse> GrantApiKeyAsync(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse> GrantApiKeyAsync(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse> GrantApiKeyAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest, Elastic.Clients.Elasticsearch.Security.GrantApiKeyResponse, Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse HasPrivileges(Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse HasPrivileges()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse HasPrivileges(System.Action<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse HasPrivileges(Elastic.Clients.Elasticsearch.Name? user)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor(user);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse HasPrivileges(Elastic.Clients.Elasticsearch.Name? user, System.Action<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor(user);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse> HasPrivilegesAsync(Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse> HasPrivilegesAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse> HasPrivilegesAsync(System.Action<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse> HasPrivilegesAsync(Elastic.Clients.Elasticsearch.Name? user, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor(user);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse> HasPrivilegesAsync(Elastic.Clients.Elasticsearch.Name? user, System.Action<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestDescriptor(user);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse HasPrivilegesUserProfile(Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse HasPrivilegesUserProfile(System.Action<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse> HasPrivilegesUserProfileAsync(Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse> HasPrivilegesUserProfileAsync(System.Action<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileResponse, Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse InvalidateApiKey(Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse InvalidateApiKey()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse InvalidateApiKey(System.Action<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse> InvalidateApiKeyAsync(Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse> InvalidateApiKeyAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse> InvalidateApiKeyAsync(System.Action<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse InvalidateToken(Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest, Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse, Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse InvalidateToken()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest, Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse, Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse InvalidateToken(System.Action<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest, Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse, Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse> InvalidateTokenAsync(Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest, Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse, Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse> InvalidateTokenAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest, Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse, Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse> InvalidateTokenAsync(System.Action<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest, Elastic.Clients.Elasticsearch.Security.InvalidateTokenResponse, Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse OidcAuthenticate(Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse OidcAuthenticate(System.Action<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse> OidcAuthenticateAsync(Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse> OidcAuthenticateAsync(System.Action<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse OidcLogout(Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest, Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse, Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse OidcLogout(System.Action<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest, Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse, Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse> OidcLogoutAsync(Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest, Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse, Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse> OidcLogoutAsync(System.Action<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest, Elastic.Clients.Elasticsearch.Security.OidcLogoutResponse, Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse OidcPrepareAuthentication(Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse OidcPrepareAuthentication()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse OidcPrepareAuthentication(System.Action<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse> OidcPrepareAuthenticationAsync(Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse> OidcPrepareAuthenticationAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse> OidcPrepareAuthenticationAsync(System.Action<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse PutPrivileges(Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse PutPrivileges(System.Action<Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse> PutPrivilegesAsync(Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse> PutPrivilegesAsync(System.Action<Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequest, Elastic.Clients.Elasticsearch.Security.PutPrivilegesResponse, Elastic.Clients.Elasticsearch.Security.PutPrivilegesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleResponse PutRole(Elastic.Clients.Elasticsearch.Security.PutRoleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleResponse PutRole(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleResponse PutRole(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleResponse PutRole<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleResponse> PutRoleAsync(Elastic.Clients.Elasticsearch.Security.PutRoleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleResponse> PutRoleAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleResponse> PutRoleAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleResponse> PutRoleAsync<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleRequest, Elastic.Clients.Elasticsearch.Security.PutRoleResponse, Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse PutRoleMapping(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse PutRoleMapping(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse PutRoleMapping(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse PutRoleMapping<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse> PutRoleMappingAsync(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse> PutRoleMappingAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse> PutRoleMappingAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse> PutRoleMappingAsync<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest, Elastic.Clients.Elasticsearch.Security.PutRoleMappingResponse, Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutUserResponse PutUser(Elastic.Clients.Elasticsearch.Security.PutUserRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutUserRequest, Elastic.Clients.Elasticsearch.Security.PutUserResponse, Elastic.Clients.Elasticsearch.Security.PutUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutUserResponse PutUser()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutUserRequest, Elastic.Clients.Elasticsearch.Security.PutUserResponse, Elastic.Clients.Elasticsearch.Security.PutUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.PutUserResponse PutUser(System.Action<Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.PutUserRequest, Elastic.Clients.Elasticsearch.Security.PutUserResponse, Elastic.Clients.Elasticsearch.Security.PutUserRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutUserResponse> PutUserAsync(Elastic.Clients.Elasticsearch.Security.PutUserRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutUserRequest, Elastic.Clients.Elasticsearch.Security.PutUserResponse, Elastic.Clients.Elasticsearch.Security.PutUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutUserResponse> PutUserAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutUserRequest, Elastic.Clients.Elasticsearch.Security.PutUserResponse, Elastic.Clients.Elasticsearch.Security.PutUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.PutUserResponse> PutUserAsync(System.Action<Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.PutUserRequest, Elastic.Clients.Elasticsearch.Security.PutUserResponse, Elastic.Clients.Elasticsearch.Security.PutUserRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse QueryApiKeys(Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse QueryApiKeys()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse QueryApiKeys(System.Action<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse QueryApiKeys<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse QueryApiKeys<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse> QueryApiKeysAsync(Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse> QueryApiKeysAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse> QueryApiKeysAsync(System.Action<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse> QueryApiKeysAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse> QueryApiKeysAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequest, Elastic.Clients.Elasticsearch.Security.QueryApiKeysResponse, Elastic.Clients.Elasticsearch.Security.QueryApiKeysRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryRoleResponse QueryRole(Elastic.Clients.Elasticsearch.Security.QueryRoleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryRoleResponse QueryRole()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryRoleResponse QueryRole(System.Action<Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryRoleResponse QueryRole<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryRoleResponse QueryRole<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryRoleResponse> QueryRoleAsync(Elastic.Clients.Elasticsearch.Security.QueryRoleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryRoleResponse> QueryRoleAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryRoleResponse> QueryRoleAsync(System.Action<Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryRoleResponse> QueryRoleAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryRoleResponse> QueryRoleAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryRoleRequest, Elastic.Clients.Elasticsearch.Security.QueryRoleResponse, Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryUserResponse QueryUser(Elastic.Clients.Elasticsearch.Security.QueryUserRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryUserResponse QueryUser()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryUserResponse QueryUser(System.Action<Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryUserResponse QueryUser<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.QueryUserResponse QueryUser<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryUserResponse> QueryUserAsync(Elastic.Clients.Elasticsearch.Security.QueryUserRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryUserResponse> QueryUserAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryUserResponse> QueryUserAsync(System.Action<Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryUserResponse> QueryUserAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.QueryUserResponse> QueryUserAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.QueryUserRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.QueryUserRequest, Elastic.Clients.Elasticsearch.Security.QueryUserResponse, Elastic.Clients.Elasticsearch.Security.QueryUserRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse SamlAuthenticate(Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse SamlAuthenticate(System.Action<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse> SamlAuthenticateAsync(Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse> SamlAuthenticateAsync(System.Action<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateResponse, Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse SamlCompleteLogout(Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse SamlCompleteLogout(System.Action<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse> SamlCompleteLogoutAsync(Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse> SamlCompleteLogoutAsync(System.Action<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse SamlInvalidate(Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest, Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse, Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse SamlInvalidate(System.Action<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest, Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse, Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse> SamlInvalidateAsync(Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest, Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse, Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse> SamlInvalidateAsync(System.Action<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest, Elastic.Clients.Elasticsearch.Security.SamlInvalidateResponse, Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse SamlLogout(Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse SamlLogout(System.Action<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse> SamlLogoutAsync(Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse> SamlLogoutAsync(System.Action<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest, Elastic.Clients.Elasticsearch.Security.SamlLogoutResponse, Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse SamlPrepareAuthentication(Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse SamlPrepareAuthentication()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse SamlPrepareAuthentication(System.Action<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse> SamlPrepareAuthenticationAsync(Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse> SamlPrepareAuthenticationAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse> SamlPrepareAuthenticationAsync(System.Action<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequest, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationResponse, Elastic.Clients.Elasticsearch.Security.SamlPrepareAuthenticationRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse SamlServiceProviderMetadata(Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse SamlServiceProviderMetadata(Elastic.Clients.Elasticsearch.Name realmName)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor(realmName);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse SamlServiceProviderMetadata(Elastic.Clients.Elasticsearch.Name realmName, System.Action<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor(realmName);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse> SamlServiceProviderMetadataAsync(Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse> SamlServiceProviderMetadataAsync(Elastic.Clients.Elasticsearch.Name realmName, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor(realmName);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse> SamlServiceProviderMetadataAsync(Elastic.Clients.Elasticsearch.Name realmName, System.Action<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor(realmName);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataResponse, Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse SuggestUserProfiles(Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse SuggestUserProfiles()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse SuggestUserProfiles(System.Action<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse> SuggestUserProfilesAsync(Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse> SuggestUserProfilesAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse> SuggestUserProfilesAsync(System.Action<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesResponse, Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse UpdateApiKey(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse UpdateApiKey(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse UpdateApiKey(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse UpdateApiKey<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse> UpdateApiKeyAsync(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse> UpdateApiKeyAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse> UpdateApiKeyAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse> UpdateApiKeyAsync<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse UpdateCrossClusterApiKey(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse UpdateCrossClusterApiKey(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse UpdateCrossClusterApiKey(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse UpdateCrossClusterApiKey<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse> UpdateCrossClusterApiKeyAsync(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse> UpdateCrossClusterApiKeyAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse> UpdateCrossClusterApiKeyAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse> UpdateCrossClusterApiKeyAsync<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyResponse, Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse UpdateSettings(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse UpdateSettings()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse UpdateSettings(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse UpdateSettings<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse UpdateSettings<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse> UpdateSettingsAsync(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse> UpdateSettingsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse> UpdateSettingsAsync(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse> UpdateSettingsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse> UpdateSettingsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest, Elastic.Clients.Elasticsearch.Security.UpdateSettingsResponse, Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse UpdateUserProfileData(Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse UpdateUserProfileData(string uid)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse UpdateUserProfileData(string uid, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse> UpdateUserProfileDataAsync(Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse> UpdateUserProfileDataAsync(string uid, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor(uid);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse> UpdateUserProfileDataAsync(string uid, System.Action<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor(uid);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataResponse, Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestParameters>(request, cancellationToken);
	}
}