// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

public partial class RollupNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.Rollup.RollupNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected RollupNamespacedClient() : base()
	{
	}

	internal RollupNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse DeleteJob(Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest, Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse, Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse DeleteJob(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest, Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse, Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse DeleteJob(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest, Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse, Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse> DeleteJobAsync(Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest, Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse, Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse> DeleteJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest, Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse, Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse> DeleteJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest, Elastic.Clients.Elasticsearch.Rollup.DeleteJobResponse, Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse GetJobs(Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse GetJobs()
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse GetJobs(System.Action<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse GetJobs(Elastic.Clients.Elasticsearch.Id? id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse GetJobs(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse> GetJobsAsync(Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse> GetJobsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse> GetJobsAsync(System.Action<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse> GetJobsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse> GetJobsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetJobsRequest, Elastic.Clients.Elasticsearch.Rollup.GetJobsResponse, Elastic.Clients.Elasticsearch.Rollup.GetJobsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse GetRollupCaps(Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse GetRollupCaps()
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse GetRollupCaps(System.Action<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse GetRollupCaps(Elastic.Clients.Elasticsearch.Id? id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse GetRollupCaps(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse> GetRollupCapsAsync(Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse> GetRollupCapsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse> GetRollupCapsAsync(System.Action<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse> GetRollupCapsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse> GetRollupCapsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse GetRollupIndexCaps(Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse GetRollupIndexCaps(Elastic.Clients.Elasticsearch.Ids index)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestDescriptor(index);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse GetRollupIndexCaps(Elastic.Clients.Elasticsearch.Ids index, System.Action<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestDescriptor(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse> GetRollupIndexCapsAsync(Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse> GetRollupIndexCapsAsync(Elastic.Clients.Elasticsearch.Ids index, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestDescriptor(index);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse> GetRollupIndexCapsAsync(Elastic.Clients.Elasticsearch.Ids index, System.Action<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestDescriptor(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequest, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsResponse, Elastic.Clients.Elasticsearch.Rollup.GetRollupIndexCapsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.PutJobResponse PutJob(Elastic.Clients.Elasticsearch.Rollup.PutJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.PutJobResponse PutJob(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.PutJobResponse PutJob(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.PutJobResponse PutJob<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.PutJobResponse> PutJobAsync(Elastic.Clients.Elasticsearch.Rollup.PutJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.PutJobResponse> PutJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.PutJobResponse> PutJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.PutJobResponse> PutJobAsync<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.PutJobRequest, Elastic.Clients.Elasticsearch.Rollup.PutJobResponse, Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument> RollupSearch<TDocument>(Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument> RollupSearch<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument> RollupSearch<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument> RollupSearch<TDocument>(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument> RollupSearch<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse> RollupSearch<TDocument, TDocumentResponse>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse> RollupSearch<TDocument, TDocumentResponse>(System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse> RollupSearch<TDocument, TDocumentResponse>(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse> RollupSearch<TDocument, TDocumentResponse>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>> RollupSearchAsync<TDocument>(Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>> RollupSearchAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>> RollupSearchAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>> RollupSearchAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>> RollupSearchAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocument>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>> RollupSearchAsync<TDocument, TDocumentResponse>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>> RollupSearchAsync<TDocument, TDocumentResponse>(System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>> RollupSearchAsync<TDocument, TDocumentResponse>(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>> RollupSearchAsync<TDocument, TDocumentResponse>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequest, Elastic.Clients.Elasticsearch.Rollup.RollupSearchResponse<TDocumentResponse>, Elastic.Clients.Elasticsearch.Rollup.RollupSearchRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.StartJobResponse StartJob(Elastic.Clients.Elasticsearch.Rollup.StartJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.StartJobRequest, Elastic.Clients.Elasticsearch.Rollup.StartJobResponse, Elastic.Clients.Elasticsearch.Rollup.StartJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.StartJobResponse StartJob(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StartJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.StartJobRequest, Elastic.Clients.Elasticsearch.Rollup.StartJobResponse, Elastic.Clients.Elasticsearch.Rollup.StartJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.StartJobResponse StartJob(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.StartJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StartJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.StartJobRequest, Elastic.Clients.Elasticsearch.Rollup.StartJobResponse, Elastic.Clients.Elasticsearch.Rollup.StartJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.StartJobResponse> StartJobAsync(Elastic.Clients.Elasticsearch.Rollup.StartJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.StartJobRequest, Elastic.Clients.Elasticsearch.Rollup.StartJobResponse, Elastic.Clients.Elasticsearch.Rollup.StartJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.StartJobResponse> StartJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StartJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.StartJobRequest, Elastic.Clients.Elasticsearch.Rollup.StartJobResponse, Elastic.Clients.Elasticsearch.Rollup.StartJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.StartJobResponse> StartJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.StartJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StartJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.StartJobRequest, Elastic.Clients.Elasticsearch.Rollup.StartJobResponse, Elastic.Clients.Elasticsearch.Rollup.StartJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Rollup.StopJobResponse StopJob(Elastic.Clients.Elasticsearch.Rollup.StopJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.StopJobRequest, Elastic.Clients.Elasticsearch.Rollup.StopJobResponse, Elastic.Clients.Elasticsearch.Rollup.StopJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.StopJobResponse StopJob(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StopJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.StopJobRequest, Elastic.Clients.Elasticsearch.Rollup.StopJobResponse, Elastic.Clients.Elasticsearch.Rollup.StopJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual Elastic.Clients.Elasticsearch.Rollup.StopJobResponse StopJob(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.StopJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StopJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Rollup.StopJobRequest, Elastic.Clients.Elasticsearch.Rollup.StopJobResponse, Elastic.Clients.Elasticsearch.Rollup.StopJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.StopJobResponse> StopJobAsync(Elastic.Clients.Elasticsearch.Rollup.StopJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.StopJobRequest, Elastic.Clients.Elasticsearch.Rollup.StopJobResponse, Elastic.Clients.Elasticsearch.Rollup.StopJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.StopJobResponse> StopJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StopJobRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.StopJobRequest, Elastic.Clients.Elasticsearch.Rollup.StopJobResponse, Elastic.Clients.Elasticsearch.Rollup.StopJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '8.11.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Rollup.StopJobResponse> StopJobAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.Rollup.StopJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.StopJobRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Rollup.StopJobRequest, Elastic.Clients.Elasticsearch.Rollup.StopJobResponse, Elastic.Clients.Elasticsearch.Rollup.StopJobRequestParameters>(request, cancellationToken);
	}
}