// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

public partial class QueryRulesNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.QueryRules.QueryRulesNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected QueryRulesNamespacedClient() : base()
	{
	}

	internal QueryRulesNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse DeleteRule(Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse DeleteRule(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestDescriptor(rulesetId, ruleId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse DeleteRule(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestDescriptor(rulesetId, ruleId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse> DeleteRuleAsync(Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse> DeleteRuleAsync(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestDescriptor(rulesetId, ruleId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse> DeleteRuleAsync(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestDescriptor(rulesetId, ruleId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRuleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse DeleteRuleset(Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse DeleteRuleset(Elastic.Clients.Elasticsearch.Id rulesetId)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse DeleteRuleset(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse> DeleteRulesetAsync(Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse> DeleteRulesetAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse> DeleteRulesetAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.DeleteRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse GetRule(Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse GetRule(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestDescriptor(rulesetId, ruleId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse GetRule(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestDescriptor(rulesetId, ruleId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse> GetRuleAsync(Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse> GetRuleAsync(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestDescriptor(rulesetId, ruleId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse> GetRuleAsync(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestDescriptor(rulesetId, ruleId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRuleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse GetRuleset(Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse GetRuleset(Elastic.Clients.Elasticsearch.Id rulesetId)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse GetRuleset(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse> GetRulesetAsync(Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse> GetRulesetAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse> GetRulesetAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse ListRulesets(Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse ListRulesets()
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse ListRulesets(System.Action<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse> ListRulesetsAsync(Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse> ListRulesetsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse> ListRulesetsAsync(System.Action<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsResponse, Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse PutRule(Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse PutRule(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor(rulesetId, ruleId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse PutRule(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor(rulesetId, ruleId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse> PutRuleAsync(Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse> PutRuleAsync(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor(rulesetId, ruleId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse> PutRuleAsync(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor(rulesetId, ruleId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRuleResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse PutRuleset(Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse PutRuleset(Elastic.Clients.Elasticsearch.Id rulesetId)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse PutRuleset(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse> PutRulesetAsync(Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse> PutRulesetAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse> PutRulesetAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequest, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetResponse, Elastic.Clients.Elasticsearch.QueryRules.PutRulesetRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.TestResponse Test(Elastic.Clients.Elasticsearch.QueryRules.TestRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.TestRequest, Elastic.Clients.Elasticsearch.QueryRules.TestResponse, Elastic.Clients.Elasticsearch.QueryRules.TestRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.TestResponse Test(Elastic.Clients.Elasticsearch.Id rulesetId)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.TestRequest, Elastic.Clients.Elasticsearch.QueryRules.TestResponse, Elastic.Clients.Elasticsearch.QueryRules.TestRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.QueryRules.TestResponse Test(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.QueryRules.TestRequest, Elastic.Clients.Elasticsearch.QueryRules.TestResponse, Elastic.Clients.Elasticsearch.QueryRules.TestRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.TestResponse> TestAsync(Elastic.Clients.Elasticsearch.QueryRules.TestRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.TestRequest, Elastic.Clients.Elasticsearch.QueryRules.TestResponse, Elastic.Clients.Elasticsearch.QueryRules.TestRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.TestResponse> TestAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor(rulesetId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.TestRequest, Elastic.Clients.Elasticsearch.QueryRules.TestResponse, Elastic.Clients.Elasticsearch.QueryRules.TestRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.QueryRules.TestResponse> TestAsync(Elastic.Clients.Elasticsearch.Id rulesetId, System.Action<Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor(rulesetId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.QueryRules.TestRequest, Elastic.Clients.Elasticsearch.QueryRules.TestResponse, Elastic.Clients.Elasticsearch.QueryRules.TestRequestParameters>(request, cancellationToken);
	}
}