// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public partial class MachineLearningNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.MachineLearning.MachineLearningNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected MachineLearningNamespacedClient() : base()
	{
	}

	internal MachineLearningNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse ClearTrainedModelDeploymentCache(Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse ClearTrainedModelDeploymentCache(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse ClearTrainedModelDeploymentCache(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse> ClearTrainedModelDeploymentCacheAsync(Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse> ClearTrainedModelDeploymentCacheAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse> ClearTrainedModelDeploymentCacheAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequest, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheResponse, Elastic.Clients.Elasticsearch.MachineLearning.ClearTrainedModelDeploymentCacheRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse CloseJob(Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse CloseJob(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse CloseJob(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse> CloseJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse> CloseJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse> CloseJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.CloseJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse DeleteCalendar(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse DeleteCalendar(Elastic.Clients.Elasticsearch.Id calendarId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse DeleteCalendar(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse> DeleteCalendarAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse> DeleteCalendarAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse> DeleteCalendarAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse DeleteCalendarEvent(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse DeleteCalendarEvent(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Id eventId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor(calendarId, eventId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse DeleteCalendarEvent(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Id eventId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor(calendarId, eventId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse> DeleteCalendarEventAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse> DeleteCalendarEventAsync(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Id eventId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor(calendarId, eventId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse> DeleteCalendarEventAsync(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Id eventId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor(calendarId, eventId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse DeleteCalendarJob(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse DeleteCalendarJob(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestDescriptor(calendarId, jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse DeleteCalendarJob(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestDescriptor(calendarId, jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse> DeleteCalendarJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse> DeleteCalendarJobAsync(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestDescriptor(calendarId, jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse> DeleteCalendarJobAsync(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestDescriptor(calendarId, jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse DeleteDatafeed(Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse DeleteDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse DeleteDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse> DeleteDatafeedAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse> DeleteDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse> DeleteDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse DeleteDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse DeleteDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse DeleteDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse> DeleteDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse> DeleteDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse> DeleteDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse DeleteExpiredData(Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse DeleteExpiredData()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse DeleteExpiredData(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse DeleteExpiredData(Elastic.Clients.Elasticsearch.Id? jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse DeleteExpiredData(Elastic.Clients.Elasticsearch.Id? jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse> DeleteExpiredDataAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse> DeleteExpiredDataAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse> DeleteExpiredDataAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse> DeleteExpiredDataAsync(Elastic.Clients.Elasticsearch.Id? jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse> DeleteExpiredDataAsync(Elastic.Clients.Elasticsearch.Id? jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse DeleteFilter(Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse DeleteFilter(Elastic.Clients.Elasticsearch.Id filterId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse DeleteFilter(Elastic.Clients.Elasticsearch.Id filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse> DeleteFilterAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse> DeleteFilterAsync(Elastic.Clients.Elasticsearch.Id filterId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse> DeleteFilterAsync(Elastic.Clients.Elasticsearch.Id filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteFilterRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse DeleteForecast(Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse DeleteForecast(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse DeleteForecast(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse DeleteForecast(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? forecastId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId, forecastId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse DeleteForecast(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? forecastId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId, forecastId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse> DeleteForecastAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse> DeleteForecastAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse> DeleteForecastAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse> DeleteForecastAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? forecastId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId, forecastId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse> DeleteForecastAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? forecastId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestDescriptor(jobId, forecastId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteForecastRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse DeleteJob(Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse DeleteJob(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse DeleteJob(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse> DeleteJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse> DeleteJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse> DeleteJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse DeleteModelSnapshot(Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse DeleteModelSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse DeleteModelSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse> DeleteModelSnapshotAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse> DeleteModelSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse> DeleteModelSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse DeleteTrainedModel(Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse DeleteTrainedModel(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse DeleteTrainedModel(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse> DeleteTrainedModelAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse> DeleteTrainedModelAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse> DeleteTrainedModelAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse DeleteTrainedModelAlias(Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse DeleteTrainedModelAlias(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse DeleteTrainedModelAlias(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse> DeleteTrainedModelAliasAsync(Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse> DeleteTrainedModelAliasAsync(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse> DeleteTrainedModelAliasAsync(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.DeleteTrainedModelAliasRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse EstimateModelMemory(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse EstimateModelMemory()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse EstimateModelMemory(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse EstimateModelMemory<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse EstimateModelMemory<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse> EstimateModelMemoryAsync(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse> EstimateModelMemoryAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse> EstimateModelMemoryAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse> EstimateModelMemoryAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse> EstimateModelMemoryAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryResponse, Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse EvaluateDataFrame(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse EvaluateDataFrame(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse EvaluateDataFrame<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse> EvaluateDataFrameAsync(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse> EvaluateDataFrameAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse> EvaluateDataFrameAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameResponse, Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id? id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse ExplainDataFrameAnalytics<TDocument>(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse> ExplainDataFrameAnalyticsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse FlushJob(Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '9.1.0'. Forcing any buffered data to be processed is deprecated, in a future major version a datafeed will be required.")]
	public virtual Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse FlushJob(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '9.1.0'. Forcing any buffered data to be processed is deprecated, in a future major version a datafeed will be required.")]
	public virtual Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse FlushJob(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse> FlushJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '9.1.0'. Forcing any buffered data to be processed is deprecated, in a future major version a datafeed will be required.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse> FlushJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '9.1.0'. Forcing any buffered data to be processed is deprecated, in a future major version a datafeed will be required.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse> FlushJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse Forecast(Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse Forecast(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse Forecast(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse> ForecastAsync(Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse> ForecastAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse> ForecastAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequest, Elastic.Clients.Elasticsearch.MachineLearning.ForecastResponse, Elastic.Clients.Elasticsearch.MachineLearning.ForecastRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse GetBuckets(Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse GetBuckets(Elastic.Clients.Elasticsearch.Id jobId, System.DateTimeOffset? timestamp)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId, timestamp);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse GetBuckets(Elastic.Clients.Elasticsearch.Id jobId, System.DateTimeOffset? timestamp, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId, timestamp);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse GetBuckets(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse GetBuckets(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse GetBuckets<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.DateTimeOffset? timestamp, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>(jobId, timestamp);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse GetBuckets<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse> GetBucketsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse> GetBucketsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.DateTimeOffset? timestamp, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId, timestamp);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse> GetBucketsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.DateTimeOffset? timestamp, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId, timestamp);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse> GetBucketsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse> GetBucketsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse> GetBucketsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.DateTimeOffset? timestamp, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>(jobId, timestamp);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse> GetBucketsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse GetCalendarEvents(Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse GetCalendarEvents(Elastic.Clients.Elasticsearch.Id calendarId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse GetCalendarEvents(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse> GetCalendarEventsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse> GetCalendarEventsAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse> GetCalendarEventsAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarEventsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse GetCalendars(Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse GetCalendars()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse GetCalendars(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse GetCalendars(Elastic.Clients.Elasticsearch.Id? calendarId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse GetCalendars(Elastic.Clients.Elasticsearch.Id? calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse> GetCalendarsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse> GetCalendarsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse> GetCalendarsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse> GetCalendarsAsync(Elastic.Clients.Elasticsearch.Id? calendarId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse> GetCalendarsAsync(Elastic.Clients.Elasticsearch.Id? calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCalendarsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse GetCategories(Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse GetCategories(Elastic.Clients.Elasticsearch.Id jobId, string? categoryId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId, categoryId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse GetCategories(Elastic.Clients.Elasticsearch.Id jobId, string? categoryId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId, categoryId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse GetCategories(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse GetCategories(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse> GetCategoriesAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse> GetCategoriesAsync(Elastic.Clients.Elasticsearch.Id jobId, string? categoryId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId, categoryId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse> GetCategoriesAsync(Elastic.Clients.Elasticsearch.Id jobId, string? categoryId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId, categoryId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse> GetCategoriesAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse> GetCategoriesAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetCategoriesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse GetDatafeeds(Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse GetDatafeeds()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse GetDatafeeds(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse GetDatafeeds(Elastic.Clients.Elasticsearch.Ids? datafeedId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse GetDatafeeds(Elastic.Clients.Elasticsearch.Ids? datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse> GetDatafeedsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse> GetDatafeedsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse> GetDatafeedsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse> GetDatafeedsAsync(Elastic.Clients.Elasticsearch.Ids? datafeedId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse> GetDatafeedsAsync(Elastic.Clients.Elasticsearch.Ids? datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse GetDatafeedStats(Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse GetDatafeedStats()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse GetDatafeedStats(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse GetDatafeedStats(Elastic.Clients.Elasticsearch.Ids? datafeedId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse GetDatafeedStats(Elastic.Clients.Elasticsearch.Ids? datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse> GetDatafeedStatsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse> GetDatafeedStatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse> GetDatafeedStatsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse> GetDatafeedStatsAsync(Elastic.Clients.Elasticsearch.Ids? datafeedId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse> GetDatafeedStatsAsync(Elastic.Clients.Elasticsearch.Ids? datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDatafeedStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse GetDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse GetDataFrameAnalytics()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse GetDataFrameAnalytics(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse GetDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id? id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse GetDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse> GetDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse> GetDataFrameAnalyticsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse> GetDataFrameAnalyticsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse> GetDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse> GetDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse GetDataFrameAnalyticsStats(Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse GetDataFrameAnalyticsStats()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse GetDataFrameAnalyticsStats(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse GetDataFrameAnalyticsStats(Elastic.Clients.Elasticsearch.Id? id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse GetDataFrameAnalyticsStats(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse> GetDataFrameAnalyticsStatsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse> GetDataFrameAnalyticsStatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse> GetDataFrameAnalyticsStatsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse> GetDataFrameAnalyticsStatsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse> GetDataFrameAnalyticsStatsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetDataFrameAnalyticsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse GetFilters(Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse GetFilters()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse GetFilters(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse GetFilters(Elastic.Clients.Elasticsearch.Ids? filterId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse GetFilters(Elastic.Clients.Elasticsearch.Ids? filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse> GetFiltersAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse> GetFiltersAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse> GetFiltersAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse> GetFiltersAsync(Elastic.Clients.Elasticsearch.Ids? filterId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse> GetFiltersAsync(Elastic.Clients.Elasticsearch.Ids? filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetFiltersRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse GetInfluencers(Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse GetInfluencers(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse GetInfluencers(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse GetInfluencers<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse> GetInfluencersAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse> GetInfluencersAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse> GetInfluencersAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse> GetInfluencersAsync<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetInfluencersRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse GetJobs(Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse GetJobs()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse GetJobs(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse GetJobs(Elastic.Clients.Elasticsearch.Ids? jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse GetJobs(Elastic.Clients.Elasticsearch.Ids? jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse> GetJobsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse> GetJobsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse> GetJobsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse> GetJobsAsync(Elastic.Clients.Elasticsearch.Ids? jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse> GetJobsAsync(Elastic.Clients.Elasticsearch.Ids? jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse GetJobStats(Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse GetJobStats()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse GetJobStats(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse GetJobStats(Elastic.Clients.Elasticsearch.Id? jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse GetJobStats(Elastic.Clients.Elasticsearch.Id? jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse> GetJobStatsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse> GetJobStatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse> GetJobStatsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse> GetJobStatsAsync(Elastic.Clients.Elasticsearch.Id? jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse> GetJobStatsAsync(Elastic.Clients.Elasticsearch.Id? jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetJobStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse GetMemoryStats(Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse GetMemoryStats()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse GetMemoryStats(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse GetMemoryStats(Elastic.Clients.Elasticsearch.Id? nodeId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor(nodeId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse GetMemoryStats(Elastic.Clients.Elasticsearch.Id? nodeId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor(nodeId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse> GetMemoryStatsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse> GetMemoryStatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse> GetMemoryStatsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse> GetMemoryStatsAsync(Elastic.Clients.Elasticsearch.Id? nodeId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor(nodeId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse> GetMemoryStatsAsync(Elastic.Clients.Elasticsearch.Id? nodeId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestDescriptor(nodeId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetMemoryStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse GetModelSnapshots(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse GetModelSnapshots(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse GetModelSnapshots(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse GetModelSnapshots(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse GetModelSnapshots(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse GetModelSnapshots<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse GetModelSnapshots<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse> GetModelSnapshotsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse> GetModelSnapshotsAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse> GetModelSnapshotsAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse> GetModelSnapshotsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse> GetModelSnapshotsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse> GetModelSnapshotsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse> GetModelSnapshotsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse GetModelSnapshotUpgradeStats(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse GetModelSnapshotUpgradeStats(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse GetModelSnapshotUpgradeStats(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse> GetModelSnapshotUpgradeStatsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse> GetModelSnapshotUpgradeStatsAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse> GetModelSnapshotUpgradeStatsAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotUpgradeStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse GetOverallBuckets(Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse GetOverallBuckets(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse GetOverallBuckets(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse> GetOverallBucketsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse> GetOverallBucketsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse> GetOverallBucketsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse GetRecords(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse GetRecords(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse GetRecords(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse GetRecords<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse> GetRecordsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse> GetRecordsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse> GetRecordsAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse> GetRecordsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse GetTrainedModels(Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse GetTrainedModels()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse GetTrainedModels(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse GetTrainedModels(Elastic.Clients.Elasticsearch.Ids? modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse GetTrainedModels(Elastic.Clients.Elasticsearch.Ids? modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse> GetTrainedModelsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse> GetTrainedModelsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse> GetTrainedModelsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse> GetTrainedModelsAsync(Elastic.Clients.Elasticsearch.Ids? modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse> GetTrainedModelsAsync(Elastic.Clients.Elasticsearch.Ids? modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse GetTrainedModelsStats(Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse GetTrainedModelsStats()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse GetTrainedModelsStats(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse GetTrainedModelsStats(Elastic.Clients.Elasticsearch.Ids? modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse GetTrainedModelsStats(Elastic.Clients.Elasticsearch.Ids? modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse> GetTrainedModelsStatsAsync(Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse> GetTrainedModelsStatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse> GetTrainedModelsStatsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse> GetTrainedModelsStatsAsync(Elastic.Clients.Elasticsearch.Ids? modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse> GetTrainedModelsStatsAsync(Elastic.Clients.Elasticsearch.Ids? modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequest, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsResponse, Elastic.Clients.Elasticsearch.MachineLearning.GetTrainedModelsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse InferTrainedModel(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse InferTrainedModel(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse InferTrainedModel(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse InferTrainedModel<TDocument>(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse> InferTrainedModelAsync(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse> InferTrainedModelAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse> InferTrainedModelAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse> InferTrainedModelAsync<TDocument>(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse Info(Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse Info()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse Info(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse> InfoAsync(Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse> InfoAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse> InfoAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequest, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse OpenJob(Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse OpenJob(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse OpenJob(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse> OpenJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse> OpenJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse> OpenJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.OpenJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse PostCalendarEvents(Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse PostCalendarEvents(Elastic.Clients.Elasticsearch.Id calendarId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse PostCalendarEvents(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse> PostCalendarEventsAsync(Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse> PostCalendarEventsAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse> PostCalendarEventsAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PostCalendarEventsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id? id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse PreviewDataFrameAnalytics<TDocument>(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse> PreviewDataFrameAnalyticsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id? id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PreviewDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse PutCalendar(Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse PutCalendar(Elastic.Clients.Elasticsearch.Id calendarId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse PutCalendar(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse> PutCalendarAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse> PutCalendarAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor(calendarId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse> PutCalendarAsync(Elastic.Clients.Elasticsearch.Id calendarId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor(calendarId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse PutCalendarJob(Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse PutCalendarJob(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestDescriptor(calendarId, jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse PutCalendarJob(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestDescriptor(calendarId, jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse> PutCalendarJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse> PutCalendarJobAsync(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestDescriptor(calendarId, jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse> PutCalendarJobAsync(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Ids jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestDescriptor(calendarId, jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse PutDatafeed(Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse PutDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse PutDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse PutDatafeed<TDocument>(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor<TDocument>(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse> PutDatafeedAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse> PutDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse> PutDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse> PutDatafeedAsync<TDocument>(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestDescriptor<TDocument>(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse PutDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse PutDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse PutDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse PutDataFrameAnalytics<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse> PutDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse> PutDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse> PutDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse> PutDataFrameAnalyticsAsync<TDocument>(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse PutFilter(Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse PutFilter(Elastic.Clients.Elasticsearch.Id filterId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse PutFilter(Elastic.Clients.Elasticsearch.Id filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse> PutFilterAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse> PutFilterAsync(Elastic.Clients.Elasticsearch.Id filterId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse> PutFilterAsync(Elastic.Clients.Elasticsearch.Id filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutFilterRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse PutJob(Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse PutJob(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse PutJob<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse> PutJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse> PutJobAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse> PutJobAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse PutTrainedModel(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse PutTrainedModel(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse PutTrainedModel(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse PutTrainedModel<TDocument>(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor<TDocument>(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse> PutTrainedModelAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse> PutTrainedModelAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse> PutTrainedModelAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse> PutTrainedModelAsync<TDocument>(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestDescriptor<TDocument>(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse PutTrainedModelAlias(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse PutTrainedModelAlias(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse PutTrainedModelAlias(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse> PutTrainedModelAliasAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse> PutTrainedModelAliasAsync(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse> PutTrainedModelAliasAsync(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor(modelId, modelAlias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse PutTrainedModelDefinitionPart(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse PutTrainedModelDefinitionPart(Elastic.Clients.Elasticsearch.Id modelId, int part)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestDescriptor(modelId, part);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse PutTrainedModelDefinitionPart(Elastic.Clients.Elasticsearch.Id modelId, int part, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestDescriptor(modelId, part);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse> PutTrainedModelDefinitionPartAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse> PutTrainedModelDefinitionPartAsync(Elastic.Clients.Elasticsearch.Id modelId, int part, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestDescriptor(modelId, part);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse> PutTrainedModelDefinitionPartAsync(Elastic.Clients.Elasticsearch.Id modelId, int part, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestDescriptor(modelId, part);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelDefinitionPartRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse PutTrainedModelVocabulary(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse PutTrainedModelVocabulary(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse PutTrainedModelVocabulary(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse> PutTrainedModelVocabularyAsync(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse> PutTrainedModelVocabularyAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse> PutTrainedModelVocabularyAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyResponse, Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse ResetJob(Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse ResetJob(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse ResetJob(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse> ResetJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse> ResetJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse> ResetJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.ResetJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse RevertModelSnapshot(Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse RevertModelSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse RevertModelSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse> RevertModelSnapshotAsync(Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse> RevertModelSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse> RevertModelSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.RevertModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse SetUpgradeMode(Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse SetUpgradeMode()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse SetUpgradeMode(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse> SetUpgradeModeAsync(Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse> SetUpgradeModeAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse> SetUpgradeModeAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequest, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeResponse, Elastic.Clients.Elasticsearch.MachineLearning.SetUpgradeModeRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse StartDatafeed(Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse StartDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse StartDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse> StartDatafeedAsync(Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse> StartDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse> StartDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse StartDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse StartDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse StartDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse> StartDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse> StartDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse> StartDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse StartTrainedModelDeployment(Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse StartTrainedModelDeployment(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse StartTrainedModelDeployment(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse> StartTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse> StartTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse> StartTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StartTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse StopDatafeed(Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse StopDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse StopDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse> StopDatafeedAsync(Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse> StopDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse> StopDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse StopDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse StopDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse StopDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse> StopDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse> StopDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse> StopDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse StopTrainedModelDeployment(Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse StopTrainedModelDeployment(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse StopTrainedModelDeployment(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse> StopTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse> StopTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse> StopTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.StopTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse UpdateDatafeed(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse UpdateDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse UpdateDatafeed(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse UpdateDatafeed<TDocument>(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse> UpdateDatafeedAsync(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse> UpdateDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor(datafeedId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse> UpdateDatafeedAsync(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse> UpdateDatafeedAsync<TDocument>(Elastic.Clients.Elasticsearch.Id datafeedId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>(datafeedId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse UpdateDataFrameAnalytics(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse UpdateDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse UpdateDataFrameAnalytics(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse> UpdateDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse> UpdateDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor(id);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse> UpdateDataFrameAnalyticsAsync(Elastic.Clients.Elasticsearch.Id id, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor(id);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse UpdateFilter(Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse UpdateFilter(Elastic.Clients.Elasticsearch.Id filterId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse UpdateFilter(Elastic.Clients.Elasticsearch.Id filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse> UpdateFilterAsync(Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse> UpdateFilterAsync(Elastic.Clients.Elasticsearch.Id filterId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestDescriptor(filterId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse> UpdateFilterAsync(Elastic.Clients.Elasticsearch.Id filterId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestDescriptor(filterId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateFilterRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse UpdateJob(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse UpdateJob(Elastic.Clients.Elasticsearch.Id jobId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse UpdateJob(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse UpdateJob<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse> UpdateJobAsync(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse> UpdateJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor(jobId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse> UpdateJobAsync(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse> UpdateJobAsync<TDocument>(Elastic.Clients.Elasticsearch.Id jobId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>(jobId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse UpdateModelSnapshot(Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse UpdateModelSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse UpdateModelSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse> UpdateModelSnapshotAsync(Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse> UpdateModelSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse> UpdateModelSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateModelSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse UpdateTrainedModelDeployment(Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse UpdateTrainedModelDeployment(Elastic.Clients.Elasticsearch.Id modelId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse UpdateTrainedModelDeployment(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse> UpdateTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse> UpdateTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestDescriptor(modelId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse> UpdateTrainedModelDeploymentAsync(Elastic.Clients.Elasticsearch.Id modelId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestDescriptor(modelId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpdateTrainedModelDeploymentRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse UpgradeJobSnapshot(Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse UpgradeJobSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse UpgradeJobSnapshot(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse> UpgradeJobSnapshotAsync(Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse> UpgradeJobSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor(jobId, snapshotId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse> UpgradeJobSnapshotAsync(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId, System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor(jobId, snapshotId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotResponse, Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse Validate(Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse Validate()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse Validate(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse Validate<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse Validate<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse> ValidateAsync(Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse> ValidateAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse> ValidateAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse> ValidateAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse> ValidateAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse ValidateDetector(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse ValidateDetector(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse ValidateDetector<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse> ValidateDetectorAsync(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse> ValidateDetectorAsync(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse> ValidateDetectorAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorResponse, Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestParameters>(request, cancellationToken);
	}
}