// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public partial class IndicesNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.IndexManagement.IndicesNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected IndicesNamespacedClient() : base()
	{
	}

	internal IndicesNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze(Elastic.Clients.Elasticsearch.IndexName? index)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor(index);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze(Elastic.Clients.Elasticsearch.IndexName? index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse Analyze<TDocument>(Elastic.Clients.Elasticsearch.IndexName? index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync(Elastic.Clients.Elasticsearch.IndexName? index, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor(index);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync(Elastic.Clients.Elasticsearch.IndexName? index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse> AnalyzeAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName? index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse CancelMigrateReindex(Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse CancelMigrateReindex(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse CancelMigrateReindex(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse CancelMigrateReindex<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse CancelMigrateReindex<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse CancelMigrateReindex<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse> CancelMigrateReindexAsync(Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse> CancelMigrateReindexAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse> CancelMigrateReindexAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse> CancelMigrateReindexAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse> CancelMigrateReindexAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse> CancelMigrateReindexAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CancelMigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache(Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse ClearCache<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync(Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse> ClearCacheAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequest, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheResponse, Elastic.Clients.Elasticsearch.IndexManagement.ClearCacheRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse Clone(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse Clone(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor(index, target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse Clone(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse Clone<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse> CloneAsync(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse> CloneAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor(index, target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse> CloneAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse> CloneAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse Close(Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse Close(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse Close(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse Close<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse Close<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse Close<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse> CloseAsync(Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse> CloseAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse> CloseAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse> CloseAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse> CloseAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse> CloseAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CloseIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse Create(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse Create(Elastic.Clients.Elasticsearch.IndexName index)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor(index);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse Create(Elastic.Clients.Elasticsearch.IndexName index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse Create<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse Create<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse Create<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse> CreateAsync(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse> CreateAsync(Elastic.Clients.Elasticsearch.IndexName index, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor(index);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse> CreateAsync(Elastic.Clients.Elasticsearch.IndexName index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse> CreateAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse> CreateAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse> CreateAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>(index);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse CreateDataStream(Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse CreateDataStream(Elastic.Clients.Elasticsearch.DataStreamName name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse CreateDataStream(Elastic.Clients.Elasticsearch.DataStreamName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse> CreateDataStreamAsync(Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse> CreateDataStreamAsync(Elastic.Clients.Elasticsearch.DataStreamName name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse> CreateDataStreamAsync(Elastic.Clients.Elasticsearch.DataStreamName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse CreateFrom(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse CreateFrom(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor(source, dest);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse CreateFrom(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor(source, dest);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse CreateFrom<TDocument>(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>(source, dest);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse> CreateFromAsync(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse> CreateFromAsync(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor(source, dest);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse> CreateFromAsync(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor(source, dest);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse> CreateFromAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>(source, dest);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromResponse, Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats(Elastic.Clients.Elasticsearch.IndexName? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats(Elastic.Clients.Elasticsearch.IndexName? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse DataStreamsStats<TDocument>(Elastic.Clients.Elasticsearch.IndexName? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync(Elastic.Clients.Elasticsearch.IndexName? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync(Elastic.Clients.Elasticsearch.IndexName? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse> DataStreamsStatsAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse Delete(Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse Delete(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse Delete(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse Delete<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse Delete<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse Delete<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse> DeleteAsync(Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse> DeleteAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse> DeleteAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse> DeleteAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse> DeleteAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse> DeleteAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse DeleteAlias(Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse DeleteAlias(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse DeleteAlias(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse DeleteAlias<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse> DeleteAliasAsync(Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse> DeleteAliasAsync(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse> DeleteAliasAsync(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse> DeleteAliasAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteAliasRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse DeleteDataLifecycle(Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse DeleteDataLifecycle(Elastic.Clients.Elasticsearch.DataStreamNames name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse DeleteDataLifecycle(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse> DeleteDataLifecycleAsync(Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse> DeleteDataLifecycleAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse> DeleteDataLifecycleAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse DeleteDataStream(Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse DeleteDataStream(Elastic.Clients.Elasticsearch.DataStreamNames name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse DeleteDataStream(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse> DeleteDataStreamAsync(Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse> DeleteDataStreamAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse> DeleteDataStreamAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse DeleteDataStreamOptions(Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse DeleteDataStreamOptions(Elastic.Clients.Elasticsearch.DataStreamNames name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse DeleteDataStreamOptions(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse> DeleteDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse> DeleteDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse> DeleteDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse DeleteIndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse DeleteIndexTemplate(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse DeleteIndexTemplate(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse> DeleteIndexTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse> DeleteIndexTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse> DeleteIndexTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse DeleteTemplate(Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse DeleteTemplate(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse DeleteTemplate(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse> DeleteTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse> DeleteTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse> DeleteTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.DeleteTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse DiskUsage(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse DiskUsage(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse DiskUsage(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse DiskUsage<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse DiskUsage<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse DiskUsage<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse> DiskUsageAsync(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse> DiskUsageAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse> DiskUsageAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse> DiskUsageAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse> DiskUsageAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse> DiskUsageAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageResponse, Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse Downsample(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse Downsample(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor(index, targetIndex);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse Downsample(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor(index, targetIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse Downsample<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>(index, targetIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse> DownsampleAsync(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse> DownsampleAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor(index, targetIndex);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse> DownsampleAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor(index, targetIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse> DownsampleAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>(index, targetIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleResponse, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse Exists(Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse Exists(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse Exists(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse Exists<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse Exists<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse Exists<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse> ExistsAsync(Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse> ExistsAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse> ExistsAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse> ExistsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse> ExistsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse> ExistsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse ExistsAlias(Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse ExistsAlias(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse ExistsAlias(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse ExistsAlias(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse ExistsAlias(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse ExistsAlias<TDocument>(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse ExistsAlias<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse> ExistsAliasAsync(Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse> ExistsAliasAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse> ExistsAliasAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse> ExistsAliasAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse> ExistsAliasAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse> ExistsAliasAsync<TDocument>(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse> ExistsAliasAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsAliasRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse ExistsIndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse ExistsIndexTemplate(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse ExistsIndexTemplate(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse> ExistsIndexTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse> ExistsIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse> ExistsIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse ExistsTemplate(Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse ExistsTemplate(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse ExistsTemplate(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse> ExistsTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse> ExistsTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse> ExistsTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExistsTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse ExplainDataLifecycle(Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse ExplainDataLifecycle(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse ExplainDataLifecycle(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse ExplainDataLifecycle<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse ExplainDataLifecycle<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse ExplainDataLifecycle<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse> ExplainDataLifecycleAsync(Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse> ExplainDataLifecycleAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse> ExplainDataLifecycleAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse> ExplainDataLifecycleAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse> ExplainDataLifecycleAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse> ExplainDataLifecycleAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.ExplainDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse FieldUsageStats(Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse FieldUsageStats(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse FieldUsageStats(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse FieldUsageStats<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse FieldUsageStats<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse FieldUsageStats<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse> FieldUsageStatsAsync(Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse> FieldUsageStatsAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse> FieldUsageStatsAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse> FieldUsageStatsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse> FieldUsageStatsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse> FieldUsageStatsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.FieldUsageStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush(Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse Flush<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync(Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse> FlushAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.FlushRequest, Elastic.Clients.Elasticsearch.IndexManagement.FlushResponse, Elastic.Clients.Elasticsearch.IndexManagement.FlushRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge(Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse Forcemerge<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync(Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse> ForcemergeAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequest, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeResponse, Elastic.Clients.Elasticsearch.IndexManagement.ForcemergeRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse Get(Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse Get(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse Get(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse Get<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse Get<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse Get<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse> GetAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse> GetAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse> GetAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse> GetAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse> GetAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse> GetAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias<TDocument>(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse GetAlias<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync<TDocument>(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse> GetAliasAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetAliasRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse GetDataLifecycle(Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse GetDataLifecycle(Elastic.Clients.Elasticsearch.DataStreamNames name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse GetDataLifecycle(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse> GetDataLifecycleAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse> GetDataLifecycleAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse> GetDataLifecycleAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse GetDataLifecycleStats(Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse GetDataLifecycleStats()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse GetDataLifecycleStats(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse> GetDataLifecycleStatsAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse> GetDataLifecycleStatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse> GetDataLifecycleStatsAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataLifecycleStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse GetDataStream(Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse GetDataStream()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse GetDataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse GetDataStream(Elastic.Clients.Elasticsearch.DataStreamNames? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse GetDataStream(Elastic.Clients.Elasticsearch.DataStreamNames? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse> GetDataStreamAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse> GetDataStreamAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse> GetDataStreamAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse> GetDataStreamAsync(Elastic.Clients.Elasticsearch.DataStreamNames? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse> GetDataStreamAsync(Elastic.Clients.Elasticsearch.DataStreamNames? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse GetDataStreamOptions(Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse GetDataStreamOptions(Elastic.Clients.Elasticsearch.DataStreamNames name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse GetDataStreamOptions(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse> GetDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse> GetDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse> GetDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse GetDataStreamSettings(Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse GetDataStreamSettings(Elastic.Clients.Elasticsearch.Indices name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse GetDataStreamSettings(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse GetDataStreamSettings<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse GetDataStreamSettings<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse GetDataStreamSettings<TDocument>(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse> GetDataStreamSettingsAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse> GetDataStreamSettingsAsync(Elastic.Clients.Elasticsearch.Indices name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse> GetDataStreamSettingsAsync(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse> GetDataStreamSettingsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse> GetDataStreamSettingsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse> GetDataStreamSettingsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse GetFieldMapping(Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse GetFieldMapping(Elastic.Clients.Elasticsearch.Fields fields)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(fields);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse GetFieldMapping(Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse GetFieldMapping(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Fields fields)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(indices, fields);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse GetFieldMapping(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(indices, fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse GetFieldMapping<TDocument>(Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>(fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse GetFieldMapping<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>(indices, fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse> GetFieldMappingAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse> GetFieldMappingAsync(Elastic.Clients.Elasticsearch.Fields fields, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(fields);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse> GetFieldMappingAsync(Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse> GetFieldMappingAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Fields fields, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(indices, fields);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse> GetFieldMappingAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor(indices, fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse> GetFieldMappingAsync<TDocument>(Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>(fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse> GetFieldMappingAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Fields fields, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestDescriptor<TDocument>(indices, fields);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetFieldMappingRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse GetIndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse GetIndexTemplate()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse GetIndexTemplate(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse GetIndexTemplate(Elastic.Clients.Elasticsearch.Name? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse GetIndexTemplate(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse> GetIndexTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse> GetIndexTemplateAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse> GetIndexTemplateAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse> GetIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse> GetIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping(Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse GetMapping<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse> GetMappingAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMappingRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse GetMigrateReindexStatus(Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse GetMigrateReindexStatus(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse GetMigrateReindexStatus(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse GetMigrateReindexStatus<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse GetMigrateReindexStatus<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse GetMigrateReindexStatus<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse> GetMigrateReindexStatusAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse> GetMigrateReindexStatusAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse> GetMigrateReindexStatusAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse> GetMigrateReindexStatusAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse> GetMigrateReindexStatusAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse> GetMigrateReindexStatusAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetMigrateReindexStatusRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse GetSettings<TDocument>(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse> GetSettingsAsync<TDocument>(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse GetTemplate(Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse GetTemplate()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse GetTemplate(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse GetTemplate(Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse GetTemplate(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse> GetTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse> GetTemplateAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse> GetTemplateAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse> GetTemplateAsync(Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse> GetTemplateAsync(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.GetTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse MigrateReindex(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse MigrateReindex(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse> MigrateReindexAsync(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse> MigrateReindexAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse MigrateToDataStream(Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse MigrateToDataStream(Elastic.Clients.Elasticsearch.IndexName name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse MigrateToDataStream(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse MigrateToDataStream<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse MigrateToDataStream<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse MigrateToDataStream<TDocument>(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse> MigrateToDataStreamAsync(Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse> MigrateToDataStreamAsync(Elastic.Clients.Elasticsearch.IndexName name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse> MigrateToDataStreamAsync(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse> MigrateToDataStreamAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse> MigrateToDataStreamAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse> MigrateToDataStreamAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.MigrateToDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse ModifyDataStream(Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse ModifyDataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse> ModifyDataStreamAsync(Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse> ModifyDataStreamAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.ModifyDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse Open(Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse Open(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse Open(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse Open<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse Open<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse Open<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse> OpenAsync(Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse> OpenAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse> OpenAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse> OpenAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse> OpenAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse> OpenAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.OpenIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse PromoteDataStream(Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse PromoteDataStream(Elastic.Clients.Elasticsearch.IndexName name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse PromoteDataStream(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse PromoteDataStream<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse PromoteDataStream<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse PromoteDataStream<TDocument>(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse> PromoteDataStreamAsync(Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse> PromoteDataStreamAsync(Elastic.Clients.Elasticsearch.IndexName name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse> PromoteDataStreamAsync(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse> PromoteDataStreamAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse> PromoteDataStreamAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse> PromoteDataStreamAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequest, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamResponse, Elastic.Clients.Elasticsearch.IndexManagement.PromoteDataStreamRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse PutAlias(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse PutAlias(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse PutAlias(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse PutAlias<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse> PutAliasAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse> PutAliasAsync(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor(indices, name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse> PutAliasAsync(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse> PutAliasAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>(indices, name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse PutDataLifecycle(Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse PutDataLifecycle(Elastic.Clients.Elasticsearch.DataStreamNames name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse PutDataLifecycle(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse> PutDataLifecycleAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse> PutDataLifecycleAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse> PutDataLifecycleAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataLifecycleRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse PutDataStreamOptions(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse PutDataStreamOptions(Elastic.Clients.Elasticsearch.DataStreamNames name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse PutDataStreamOptions(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse> PutDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse> PutDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse> PutDataStreamOptionsAsync(Elastic.Clients.Elasticsearch.DataStreamNames name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamOptionsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse PutDataStreamSettings(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse PutDataStreamSettings(Elastic.Clients.Elasticsearch.Indices name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse PutDataStreamSettings(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse PutDataStreamSettings<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse PutDataStreamSettings<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse PutDataStreamSettings<TDocument>(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse> PutDataStreamSettingsAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse> PutDataStreamSettingsAsync(Elastic.Clients.Elasticsearch.Indices name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse> PutDataStreamSettingsAsync(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse> PutDataStreamSettingsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse> PutDataStreamSettingsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse> PutDataStreamSettingsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse PutIndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse PutIndexTemplate(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse PutIndexTemplate(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse PutIndexTemplate<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse> PutIndexTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse> PutIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse> PutIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse> PutIndexTemplateAsync<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse PutMapping(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse PutMapping(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse PutMapping(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse PutMapping<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse PutMapping<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse PutMapping<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse> PutMappingAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse> PutMappingAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse> PutMappingAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse> PutMappingAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse> PutMappingAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse> PutMappingAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse PutSettings(Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse PutSettings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse PutSettings(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse PutSettings(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse PutSettings<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse PutSettings<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse> PutSettingsAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse> PutSettingsAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse> PutSettingsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse> PutSettingsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse> PutSettingsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse> PutSettingsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutIndicesSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse PutTemplate(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse PutTemplate(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse PutTemplate(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse PutTemplate<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse> PutTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse> PutTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse> PutTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request, cancellationToken);
	}

	[System.Obsolete("Deprecated in '7.8.0'.")]
	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse> PutTemplateAsync<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery(Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse Recovery<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync(Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse> RecoveryAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequest, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryResponse, Elastic.Clients.Elasticsearch.IndexManagement.RecoveryRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh(Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse Refresh<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync(Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse> RefreshAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequest, Elastic.Clients.Elasticsearch.IndexManagement.RefreshResponse, Elastic.Clients.Elasticsearch.IndexManagement.RefreshRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse ReloadSearchAnalyzers(Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse ReloadSearchAnalyzers(Elastic.Clients.Elasticsearch.Indices indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse ReloadSearchAnalyzers(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse ReloadSearchAnalyzers<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse ReloadSearchAnalyzers<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse ReloadSearchAnalyzers<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse> ReloadSearchAnalyzersAsync(Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse> ReloadSearchAnalyzersAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse> ReloadSearchAnalyzersAsync(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse> ReloadSearchAnalyzersAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse> ReloadSearchAnalyzersAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse> ReloadSearchAnalyzersAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequest, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersResponse, Elastic.Clients.Elasticsearch.IndexManagement.ReloadSearchAnalyzersRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse RemoveBlock(Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse RemoveBlock(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexManagement.IndicesBlockOptions block)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor(index, block);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse RemoveBlock(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexManagement.IndicesBlockOptions block, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor(index, block);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse RemoveBlock<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexManagement.IndicesBlockOptions block, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor<TDocument>(index, block);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse> RemoveBlockAsync(Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse> RemoveBlockAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexManagement.IndicesBlockOptions block, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor(index, block);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse> RemoveBlockAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexManagement.IndicesBlockOptions block, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor(index, block);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse> RemoveBlockAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexManagement.IndicesBlockOptions block, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestDescriptor<TDocument>(index, block);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequest, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockResponse, Elastic.Clients.Elasticsearch.IndexManagement.RemoveBlockRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse ResolveCluster(Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse ResolveCluster()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse ResolveCluster(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse ResolveCluster(Elastic.Clients.Elasticsearch.Names? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse ResolveCluster(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse> ResolveClusterAsync(Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse> ResolveClusterAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse> ResolveClusterAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse> ResolveClusterAsync(Elastic.Clients.Elasticsearch.Names? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse> ResolveClusterAsync(Elastic.Clients.Elasticsearch.Names? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveClusterRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse ResolveIndex(Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse ResolveIndex(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse ResolveIndex(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse> ResolveIndexAsync(Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse> ResolveIndexAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse> ResolveIndexAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ResolveIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse Rollover(Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse Rollover(Elastic.Clients.Elasticsearch.IndexAlias alias)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse Rollover(Elastic.Clients.Elasticsearch.IndexAlias alias, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse Rollover(Elastic.Clients.Elasticsearch.IndexAlias alias, Elastic.Clients.Elasticsearch.IndexName? newIndex)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias, newIndex);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse Rollover(Elastic.Clients.Elasticsearch.IndexAlias alias, Elastic.Clients.Elasticsearch.IndexName? newIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias, newIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse Rollover<TDocument>(Elastic.Clients.Elasticsearch.IndexAlias alias, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>(alias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse Rollover<TDocument>(Elastic.Clients.Elasticsearch.IndexAlias alias, Elastic.Clients.Elasticsearch.IndexName? newIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>(alias, newIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse> RolloverAsync(Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse> RolloverAsync(Elastic.Clients.Elasticsearch.IndexAlias alias, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse> RolloverAsync(Elastic.Clients.Elasticsearch.IndexAlias alias, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse> RolloverAsync(Elastic.Clients.Elasticsearch.IndexAlias alias, Elastic.Clients.Elasticsearch.IndexName? newIndex, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias, newIndex);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse> RolloverAsync(Elastic.Clients.Elasticsearch.IndexAlias alias, Elastic.Clients.Elasticsearch.IndexName? newIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor(alias, newIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse> RolloverAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexAlias alias, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>(alias);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse> RolloverAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexAlias alias, Elastic.Clients.Elasticsearch.IndexName? newIndex, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestDescriptor<TDocument>(alias, newIndex);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequest, Elastic.Clients.Elasticsearch.IndexManagement.RolloverResponse, Elastic.Clients.Elasticsearch.IndexManagement.RolloverRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments(Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse Segments<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync(Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse> SegmentsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequest, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsResponse, Elastic.Clients.Elasticsearch.IndexManagement.SegmentsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores(Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse ShardStores<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync(Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse> ShardStoresAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoresRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse Shrink(Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse Shrink(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor(index, target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse Shrink(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse Shrink<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor<TDocument>(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse> ShrinkAsync(Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse> ShrinkAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor(index, target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse> ShrinkAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse> ShrinkAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestDescriptor<TDocument>(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.ShrinkIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse SimulateIndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse SimulateIndexTemplate(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse SimulateIndexTemplate(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse SimulateIndexTemplate<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse> SimulateIndexTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse> SimulateIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse> SimulateIndexTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse> SimulateIndexTemplateAsync<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate(Elastic.Clients.Elasticsearch.Name? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse SimulateTemplate<TDocument>(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync(Elastic.Clients.Elasticsearch.Name? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse> SimulateTemplateAsync<TDocument>(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateResponse, Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse Split(Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse Split(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor(index, target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse Split(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse Split<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor<TDocument>(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse> SplitAsync(Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse> SplitAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor(index, target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse> SplitAsync(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse> SplitAsync<TDocument>(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName target, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestDescriptor<TDocument>(index, target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequest, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexResponse, Elastic.Clients.Elasticsearch.IndexManagement.SplitIndexRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(Elastic.Clients.Elasticsearch.Metrics? metric)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(metric);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices, metric);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices, metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats<TDocument>(Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse Stats<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(indices, metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.Metrics? metric, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(metric);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices, metric);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(indices, metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync<TDocument>(Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse> StatsAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(indices, metric);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsResponse, Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse UpdateAliases(Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse UpdateAliases()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse UpdateAliases(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse UpdateAliases<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse UpdateAliases<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse> UpdateAliasesAsync(Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse> UpdateAliasesAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse> UpdateAliasesAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse> UpdateAliasesAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse> UpdateAliasesAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequest, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesResponse, Elastic.Clients.Elasticsearch.IndexManagement.UpdateAliasesRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery(Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse ValidateQuery<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync(Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse> ValidateQueryAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequest, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryResponse, Elastic.Clients.Elasticsearch.IndexManagement.ValidateQueryRequestParameters>(request, cancellationToken);
	}
}