// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

public partial class ClusterNamespacedClient : Elastic.Clients.Elasticsearch.NamespacedClientProxy
{
	/// <summary>
	/// <para>
	/// Initializes a new instance of the <see cref="Elastic.Clients.Elasticsearch.Cluster.ClusterNamespacedClient"/> class for mocking.
	/// </para>
	/// </summary>
	protected ClusterNamespacedClient() : base()
	{
	}

	internal ClusterNamespacedClient(Elastic.Clients.Elasticsearch.ElasticsearchClient client) : base(client)
	{
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse AllocationExplain(Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse AllocationExplain()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse AllocationExplain(System.Action<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse> AllocationExplainAsync(Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse> AllocationExplainAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse> AllocationExplainAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse DeleteComponentTemplate(Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse DeleteComponentTemplate(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse DeleteComponentTemplate(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse> DeleteComponentTemplateAsync(Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse> DeleteComponentTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse> DeleteComponentTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse DeleteVotingConfigExclusions(Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse DeleteVotingConfigExclusions()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse DeleteVotingConfigExclusions(System.Action<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse> DeleteVotingConfigExclusionsAsync(Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse> DeleteVotingConfigExclusionsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse> DeleteVotingConfigExclusionsAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.DeleteVotingConfigExclusionsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse ExistsComponentTemplate(Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse ExistsComponentTemplate(Elastic.Clients.Elasticsearch.Names name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse ExistsComponentTemplate(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse> ExistsComponentTemplateAsync(Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse> ExistsComponentTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse> ExistsComponentTemplateAsync(Elastic.Clients.Elasticsearch.Names name, System.Action<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.ExistsComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse GetComponentTemplate(Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse GetComponentTemplate()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse GetComponentTemplate(System.Action<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse GetComponentTemplate(Elastic.Clients.Elasticsearch.Name? name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse GetComponentTemplate(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse> GetComponentTemplateAsync(Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse> GetComponentTemplateAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse> GetComponentTemplateAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse> GetComponentTemplateAsync(Elastic.Clients.Elasticsearch.Name? name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse> GetComponentTemplateAsync(Elastic.Clients.Elasticsearch.Name? name, System.Action<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse GetSettings(Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse GetSettings()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse GetSettings(System.Action<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse> GetSettingsAsync(Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse> GetSettingsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse> GetSettingsAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequest, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsResponse, Elastic.Clients.Elasticsearch.Cluster.GetClusterSettingsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health(Elastic.Clients.Elasticsearch.Cluster.HealthRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health(System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health<TDocument>()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.HealthResponse Health<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync(Elastic.Clients.Elasticsearch.Cluster.HealthRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor(indices);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync<TDocument>(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync<TDocument>(System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.HealthResponse> HealthAsync<TDocument>(Elastic.Clients.Elasticsearch.Indices? indices, System.Action<Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.HealthRequestDescriptor<TDocument>(indices);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.HealthRequest, Elastic.Clients.Elasticsearch.Cluster.HealthResponse, Elastic.Clients.Elasticsearch.Cluster.HealthRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse Info(Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse Info(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> target)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor(target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse Info(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> target, System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor(target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse> InfoAsync(Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse> InfoAsync(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> target, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor(target);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse> InfoAsync(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> target, System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor(target);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse PendingTasks(Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest, Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse, Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse PendingTasks()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest, Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse, Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse PendingTasks(System.Action<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest, Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse, Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse> PendingTasksAsync(Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest, Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse, Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse> PendingTasksAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest, Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse, Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse> PendingTasksAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequest, Elastic.Clients.Elasticsearch.Cluster.PendingTasksResponse, Elastic.Clients.Elasticsearch.Cluster.PendingTasksRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse PostVotingConfigExclusions(Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse PostVotingConfigExclusions()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse PostVotingConfigExclusions(System.Action<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse> PostVotingConfigExclusionsAsync(Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse> PostVotingConfigExclusionsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse> PostVotingConfigExclusionsAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequest, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsResponse, Elastic.Clients.Elasticsearch.Cluster.PostVotingConfigExclusionsRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse PutComponentTemplate(Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse PutComponentTemplate(Elastic.Clients.Elasticsearch.Name name)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse PutComponentTemplate(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse PutComponentTemplate<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse> PutComponentTemplateAsync(Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse> PutComponentTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor(name);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse> PutComponentTemplateAsync(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse> PutComponentTemplateAsync<TDocument>(Elastic.Clients.Elasticsearch.Name name, System.Action<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor<TDocument>> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestDescriptor<TDocument>(name);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequest, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateResponse, Elastic.Clients.Elasticsearch.Cluster.PutComponentTemplateRequestParameters>(request, cancellationToken);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse Stats(Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest request)
	{
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse Stats()
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse Stats(System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse Stats(Elastic.Clients.Elasticsearch.NodeIds? nodeId)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor(nodeId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request);
	}

	public virtual Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse Stats(Elastic.Clients.Elasticsearch.NodeIds? nodeId, System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor(nodeId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest request, System.Threading.CancellationToken cancellationToken = default)
	{
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse> StatsAsync(System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor();
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse> StatsAsync(System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor();
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.NodeIds? nodeId, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor(nodeId);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request, cancellationToken);
	}

	public virtual System.Threading.Tasks.Task<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse> StatsAsync(Elastic.Clients.Elasticsearch.NodeIds? nodeId, System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor> action, System.Threading.CancellationToken cancellationToken = default)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor(nodeId);
		action.Invoke(builder);
		var request = builder.Instance;
		request.BeforeRequest();
		return DoRequestAsync<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsResponse, Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>(request, cancellationToken);
	}
}