// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack;

public sealed partial class XpackInfoRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If this param is used it must be set to true
	/// </para>
	/// </summary>
	public bool? AcceptEnterprise { get => Q<bool?>("accept_enterprise"); set => Q("accept_enterprise", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of the information categories to include in the response.
	/// For example, <c>build,license,features</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Xpack.XPackCategory>? Categories { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Xpack.XPackCategory>?>("categories"); set => Q("categories", value); }
}

/// <summary>
/// <para>
/// Get information.
/// The information provided by the API includes:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Build information including the build number and timestamp.
/// </para>
/// </item>
/// <item>
/// <para>
/// License information about the currently installed license.
/// </para>
/// </item>
/// <item>
/// <para>
/// Feature information for the features that are currently enabled and available under the current license.
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Xpack.Json.XpackInfoRequestConverter))]
public sealed partial class XpackInfoRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestParameters>
{
#if NET7_0_OR_GREATER
	public XpackInfoRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public XpackInfoRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal XpackInfoRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.XpackInfo;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "xpack.info";

	/// <summary>
	/// <para>
	/// If this param is used it must be set to true
	/// </para>
	/// </summary>
	public bool? AcceptEnterprise { get => Q<bool?>("accept_enterprise"); set => Q("accept_enterprise", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of the information categories to include in the response.
	/// For example, <c>build,license,features</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Xpack.XPackCategory>? Categories { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Xpack.XPackCategory>?>("categories"); set => Q("categories", value); }
}

/// <summary>
/// <para>
/// Get information.
/// The information provided by the API includes:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Build information including the build number and timestamp.
/// </para>
/// </item>
/// <item>
/// <para>
/// License information about the currently installed license.
/// </para>
/// </item>
/// <item>
/// <para>
/// Feature information for the features that are currently enabled and available under the current license.
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct XpackInfoRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public XpackInfoRequestDescriptor(Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest instance)
	{
		Instance = instance;
	}

	public XpackInfoRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor(Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest instance) => new Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest(Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If this param is used it must be set to true
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor AcceptEnterprise(bool? value = true)
	{
		Instance.AcceptEnterprise = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of the information categories to include in the response.
	/// For example, <c>build,license,features</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor Categories(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Xpack.XPackCategory>? value)
	{
		Instance.Categories = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of the information categories to include in the response.
	/// For example, <c>build,license,features</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor Categories(params Elastic.Clients.Elasticsearch.Xpack.XPackCategory[] values)
	{
		Instance.Categories = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest Build(System.Action<Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor(new Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Xpack.XpackInfoRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}