// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.UpdateResponseConverterFactory))]
public sealed partial class UpdateResponse<TDocument> : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The role of the failure store in this document response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus? FailureStore { get; set; }
	public bool? ForcedRefresh { get; set; }
	public Elastic.Clients.Elasticsearch.InlineGet<TDocument>? Get { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for the added document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index the document was added to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Index { get; set; }

	/// <summary>
	/// <para>
	/// The primary term assigned to the document for the indexing operation.
	/// </para>
	/// </summary>
	public long? PrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The result of the indexing operation: <c>created</c> or <c>updated</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Result Result { get; set; }

	/// <summary>
	/// <para>
	/// The sequence number assigned to the document for the indexing operation.
	/// Sequence numbers are used to ensure an older version of a document doesn't overwrite a newer version.
	/// </para>
	/// </summary>
	public long? SeqNo { get; set; }

	/// <summary>
	/// <para>
	/// Information about the replication process of the operation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ShardStatistics Shards { get; set; }

	/// <summary>
	/// <para>
	/// The document version, which is incremented each time the document is updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Version { get; set; }
}