// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement.Json;

public sealed partial class UpgradeTransformsResponseConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse>
{
	private static readonly System.Text.Json.JsonEncodedText PropNeedsUpdate = System.Text.Json.JsonEncodedText.Encode("needs_update");
	private static readonly System.Text.Json.JsonEncodedText PropNoAction = System.Text.Json.JsonEncodedText.Encode("no_action");
	private static readonly System.Text.Json.JsonEncodedText PropUpdated = System.Text.Json.JsonEncodedText.Encode("updated");

	public override Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propNeedsUpdate = default;
		LocalJsonValue<int> propNoAction = default;
		LocalJsonValue<int> propUpdated = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propNeedsUpdate.TryReadProperty(ref reader, options, PropNeedsUpdate, null))
			{
				continue;
			}

			if (propNoAction.TryReadProperty(ref reader, options, PropNoAction, null))
			{
				continue;
			}

			if (propUpdated.TryReadProperty(ref reader, options, PropUpdated, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			NeedsUpdate = propNeedsUpdate.Value,
			NoAction = propNoAction.Value,
			Updated = propUpdated.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TransformManagement.UpgradeTransformsResponse value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropNeedsUpdate, value.NeedsUpdate, null, null);
		writer.WriteProperty(options, PropNoAction, value.NoAction, null, null);
		writer.WriteProperty(options, PropUpdated, value.Updated, null, null);
		writer.WriteEndObject();
	}
}