// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

public sealed partial class StartTransformRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Restricts the set of transformed entities to those changed after this time. Relative times like now-30d are supported. Only applicable for continuous transforms.
	/// </para>
	/// </summary>
	public string? From { get => Q<string?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Start a transform.
/// </para>
/// <para>
/// When you start a transform, it creates the destination index if it does not already exist. The <c>number_of_shards</c> is
/// set to <c>1</c> and the <c>auto_expand_replicas</c> is set to <c>0-1</c>. If it is a pivot transform, it deduces the mapping
/// definitions for the destination index from the source indices and the transform aggregations. If fields in the
/// destination index are derived from scripts (as in the case of <c>scripted_metric</c> or <c>bucket_script</c> aggregations),
/// the transform uses dynamic mappings unless an index template exists. If it is a latest transform, it does not deduce
/// mapping definitions; it uses dynamic mappings. To use explicit mappings, create the destination index before you
/// start the transform. Alternatively, you can create an index template, though it does not affect the deduced mappings
/// in a pivot transform.
/// </para>
/// <para>
/// When the transform starts, a series of validations occur to ensure its success. If you deferred validation when you
/// created the transform, they occur when you start the transform—​with the exception of privilege checks. When
/// Elasticsearch security features are enabled, the transform remembers which roles the user that created it had at the
/// time of creation and uses those same roles. If those roles do not have the required privileges on the source and
/// destination indices, the transform fails when it attempts unauthorized operations.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.StartTransformRequestConverter))]
public sealed partial class StartTransformRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StartTransformRequest(Elastic.Clients.Elasticsearch.Id transformId) : base(r => r.Required("transform_id", transformId))
	{
	}
#if NET7_0_OR_GREATER
	public StartTransformRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StartTransformRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.TransformManagementStartTransform;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "transform.start_transform";

	/// <summary>
	/// <para>
	/// Identifier for the transform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id TransformId { get => P<Elastic.Clients.Elasticsearch.Id>("transform_id"); set => PR("transform_id", value); }

	/// <summary>
	/// <para>
	/// Restricts the set of transformed entities to those changed after this time. Relative times like now-30d are supported. Only applicable for continuous transforms.
	/// </para>
	/// </summary>
	public string? From { get => Q<string?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Start a transform.
/// </para>
/// <para>
/// When you start a transform, it creates the destination index if it does not already exist. The <c>number_of_shards</c> is
/// set to <c>1</c> and the <c>auto_expand_replicas</c> is set to <c>0-1</c>. If it is a pivot transform, it deduces the mapping
/// definitions for the destination index from the source indices and the transform aggregations. If fields in the
/// destination index are derived from scripts (as in the case of <c>scripted_metric</c> or <c>bucket_script</c> aggregations),
/// the transform uses dynamic mappings unless an index template exists. If it is a latest transform, it does not deduce
/// mapping definitions; it uses dynamic mappings. To use explicit mappings, create the destination index before you
/// start the transform. Alternatively, you can create an index template, though it does not affect the deduced mappings
/// in a pivot transform.
/// </para>
/// <para>
/// When the transform starts, a series of validations occur to ensure its success. If you deferred validation when you
/// created the transform, they occur when you start the transform—​with the exception of privilege checks. When
/// Elasticsearch security features are enabled, the transform remembers which roles the user that created it had at the
/// time of creation and uses those same roles. If those roles do not have the required privileges on the source and
/// destination indices, the transform fails when it attempts unauthorized operations.
/// </para>
/// </summary>
public readonly partial struct StartTransformRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StartTransformRequestDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest instance)
	{
		Instance = instance;
	}

	public StartTransformRequestDescriptor(Elastic.Clients.Elasticsearch.Id transformId)
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest(transformId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public StartTransformRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest instance) => new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest(Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the transform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor TransformId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.TransformId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Restricts the set of transformed entities to those changed after this time. Relative times like now-30d are supported. Only applicable for continuous transforms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor From(string? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.StartTransformRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}