// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

public sealed partial class SetUpgradeModeRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// When <c>true</c>, it enables <c>upgrade_mode</c> which temporarily halts all
	/// transform tasks and prohibits new transform tasks from
	/// starting.
	/// </para>
	/// </summary>
	public bool? Enabled { get => Q<bool?>("enabled"); set => Q("enabled", value); }

	/// <summary>
	/// <para>
	/// The time to wait for the request to be completed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Set upgrade_mode for transform indices.
/// Sets a cluster wide upgrade_mode setting that prepares transform
/// indices for an upgrade.
/// When upgrading your cluster, in some circumstances you must restart your
/// nodes and reindex your transform indices. In those circumstances,
/// there must be no transforms running. You can close the transforms,
/// do the upgrade, then open all the transforms again. Alternatively,
/// you can use this API to temporarily halt tasks associated with the transforms
/// and prevent new transforms from opening. You can also use this API
/// during upgrades that do not require you to reindex your transform
/// indices, though stopping transforms is not a requirement in that case.
/// You can see the current value for the upgrade_mode setting by using the get
/// transform info API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.SetUpgradeModeRequestConverter))]
public sealed partial class SetUpgradeModeRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestParameters>
{
#if NET7_0_OR_GREATER
	public SetUpgradeModeRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SetUpgradeModeRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SetUpgradeModeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.TransformManagementSetUpgradeMode;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "transform.set_upgrade_mode";

	/// <summary>
	/// <para>
	/// When <c>true</c>, it enables <c>upgrade_mode</c> which temporarily halts all
	/// transform tasks and prohibits new transform tasks from
	/// starting.
	/// </para>
	/// </summary>
	public bool? Enabled { get => Q<bool?>("enabled"); set => Q("enabled", value); }

	/// <summary>
	/// <para>
	/// The time to wait for the request to be completed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Set upgrade_mode for transform indices.
/// Sets a cluster wide upgrade_mode setting that prepares transform
/// indices for an upgrade.
/// When upgrading your cluster, in some circumstances you must restart your
/// nodes and reindex your transform indices. In those circumstances,
/// there must be no transforms running. You can close the transforms,
/// do the upgrade, then open all the transforms again. Alternatively,
/// you can use this API to temporarily halt tasks associated with the transforms
/// and prevent new transforms from opening. You can also use this API
/// during upgrades that do not require you to reindex your transform
/// indices, though stopping transforms is not a requirement in that case.
/// You can see the current value for the upgrade_mode setting by using the get
/// transform info API.
/// </para>
/// </summary>
public readonly partial struct SetUpgradeModeRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SetUpgradeModeRequestDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest instance)
	{
		Instance = instance;
	}

	public SetUpgradeModeRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest instance) => new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest(Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// When <c>true</c>, it enables <c>upgrade_mode</c> which temporarily halts all
	/// transform tasks and prohibits new transform tasks from
	/// starting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The time to wait for the request to be completed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.SetUpgradeModeRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}