// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

public sealed partial class GetTransformRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies what to do when the request:
	/// </para>
	/// <list type="number">
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are no transforms that match.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains the _all string or no identifiers and there are no matches.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are only partial matches.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// If this parameter is false, the request returns a 404 status code when
	/// there are no matches or only partial matches.
	/// </para>
	/// </summary>
	public bool? AllowNoMatch { get => Q<bool?>("allow_no_match"); set => Q("allow_no_match", value); }

	/// <summary>
	/// <para>
	/// Excludes fields that were automatically added when creating the
	/// transform. This allows the configuration to be in an acceptable format to
	/// be retrieved and then added to another cluster.
	/// </para>
	/// </summary>
	public bool? ExcludeGenerated { get => Q<bool?>("exclude_generated"); set => Q("exclude_generated", value); }

	/// <summary>
	/// <para>
	/// Skips the specified number of transforms.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of transforms to obtain.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get transforms.
/// Get configuration information for transforms.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.GetTransformRequestConverter))]
public sealed partial class GetTransformRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestParameters>
{
	public GetTransformRequest(Elastic.Clients.Elasticsearch.Names? transformId) : base(r => r.Optional("transform_id", transformId))
	{
	}
#if NET7_0_OR_GREATER
	public GetTransformRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetTransformRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetTransformRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.TransformManagementGetTransform;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "transform.get_transform";

	/// <summary>
	/// <para>
	/// Identifier for the transform. It can be a transform identifier or a
	/// wildcard expression. You can get information for all transforms by using
	/// <c>_all</c>, by specifying <c>*</c> as the <c>&lt;transform_id></c>, or by omitting the
	/// <c>&lt;transform_id></c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Names? TransformId { get => P<Elastic.Clients.Elasticsearch.Names?>("transform_id"); set => PO("transform_id", value); }

	/// <summary>
	/// <para>
	/// Specifies what to do when the request:
	/// </para>
	/// <list type="number">
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are no transforms that match.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains the _all string or no identifiers and there are no matches.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are only partial matches.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// If this parameter is false, the request returns a 404 status code when
	/// there are no matches or only partial matches.
	/// </para>
	/// </summary>
	public bool? AllowNoMatch { get => Q<bool?>("allow_no_match"); set => Q("allow_no_match", value); }

	/// <summary>
	/// <para>
	/// Excludes fields that were automatically added when creating the
	/// transform. This allows the configuration to be in an acceptable format to
	/// be retrieved and then added to another cluster.
	/// </para>
	/// </summary>
	public bool? ExcludeGenerated { get => Q<bool?>("exclude_generated"); set => Q("exclude_generated", value); }

	/// <summary>
	/// <para>
	/// Skips the specified number of transforms.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of transforms to obtain.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get transforms.
/// Get configuration information for transforms.
/// </para>
/// </summary>
public readonly partial struct GetTransformRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetTransformRequestDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest instance)
	{
		Instance = instance;
	}

	public GetTransformRequestDescriptor(Elastic.Clients.Elasticsearch.Names? transformId)
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest(transformId);
	}

	public GetTransformRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor(Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest instance) => new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest(Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the transform. It can be a transform identifier or a
	/// wildcard expression. You can get information for all transforms by using
	/// <c>_all</c>, by specifying <c>*</c> as the <c>&lt;transform_id></c>, or by omitting the
	/// <c>&lt;transform_id></c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor TransformId(Elastic.Clients.Elasticsearch.Names? value)
	{
		Instance.TransformId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies what to do when the request:
	/// </para>
	/// <list type="number">
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are no transforms that match.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains the _all string or no identifiers and there are no matches.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are only partial matches.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// If this parameter is false, the request returns a 404 status code when
	/// there are no matches or only partial matches.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor AllowNoMatch(bool? value = true)
	{
		Instance.AllowNoMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Excludes fields that were automatically added when creating the
	/// transform. This allows the configuration to be in an acceptable format to
	/// be retrieved and then added to another cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor ExcludeGenerated(bool? value = true)
	{
		Instance.ExcludeGenerated = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Skips the specified number of transforms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of transforms to obtain.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest Build(System.Action<Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor(new Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TransformManagement.GetTransformRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}