// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TextStructure;

public sealed partial class TestGrokPatternRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The mode of compatibility with ECS compliant Grok patterns.
	/// Use this parameter to specify whether to use ECS Grok patterns instead of legacy ones when the structure finder creates a Grok pattern.
	/// Valid values are <c>disabled</c> and <c>v1</c>.
	/// </para>
	/// </summary>
	public string? EcsCompatibility { get => Q<string?>("ecs_compatibility"); set => Q("ecs_compatibility", value); }
}

/// <summary>
/// <para>
/// Test a Grok pattern.
/// Test a Grok pattern on one or more lines of text.
/// The API indicates whether the lines match the pattern together with the offsets and lengths of the matched substrings.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TextStructure.Json.TestGrokPatternRequestConverter))]
public sealed partial class TestGrokPatternRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TestGrokPatternRequest(string grokPattern, System.Collections.Generic.ICollection<string> text)
	{
		GrokPattern = grokPattern;
		Text = text;
	}
#if NET7_0_OR_GREATER
	public TestGrokPatternRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TestGrokPatternRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TestGrokPatternRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.TextStructureTestGrokPattern;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "text_structure.test_grok_pattern";

	/// <summary>
	/// <para>
	/// The mode of compatibility with ECS compliant Grok patterns.
	/// Use this parameter to specify whether to use ECS Grok patterns instead of legacy ones when the structure finder creates a Grok pattern.
	/// Valid values are <c>disabled</c> and <c>v1</c>.
	/// </para>
	/// </summary>
	public string? EcsCompatibility { get => Q<string?>("ecs_compatibility"); set => Q("ecs_compatibility", value); }

	/// <summary>
	/// <para>
	/// The Grok pattern to run on the text.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string GrokPattern { get; set; }

	/// <summary>
	/// <para>
	/// The lines of text to run the Grok pattern on.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Text { get; set; }
}

/// <summary>
/// <para>
/// Test a Grok pattern.
/// Test a Grok pattern on one or more lines of text.
/// The API indicates whether the lines match the pattern together with the offsets and lengths of the matched substrings.
/// </para>
/// </summary>
public readonly partial struct TestGrokPatternRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TestGrokPatternRequestDescriptor(Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequest instance)
	{
		Instance = instance;
	}

	public TestGrokPatternRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor(Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequest instance) => new Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequest(Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The mode of compatibility with ECS compliant Grok patterns.
	/// Use this parameter to specify whether to use ECS Grok patterns instead of legacy ones when the structure finder creates a Grok pattern.
	/// Valid values are <c>disabled</c> and <c>v1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor EcsCompatibility(string? value)
	{
		Instance.EcsCompatibility = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Grok pattern to run on the text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor GrokPattern(string value)
	{
		Instance.GrokPattern = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The lines of text to run the Grok pattern on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor Text(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Text = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The lines of text to run the Grok pattern on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor Text(params string[] values)
	{
		Instance.Text = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequest Build(System.Action<Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor(new Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.TextStructure.TestGrokPatternRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}